/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "options.h"
#include "io.h"
#include "string_table.h"
#include "query_code.h"
#include "procedures.h"


extern void close_input (void);
extern void close_output (void);

int
dump_code(void)
{
	write_string_table();
	write_query_code();
	write_procedures();
	}

main(int argc, char **argv)
{
	OPTIONS ("-i inputfilename -o outputfilename")
                STRING  ('i', input_filename)
                STRING  ('o', output_filename)
	ENDOPTS

	/* SET UP STREAMS */
	initialize_input();
	initialize_output();

	/* READ ASSEMBLER */
	yyinit();
	yyparse();

	/* DUMP CODE */
	/*if(!yyerrs)*/
		dump_code();

	/* CLOSE STREAMS */
	close_input();
	close_output();
	exit(0);
	}

