/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <stdio.h>
#include "cells.h"
#include "io.h"
#include "instruction_sizes.h"
#include "labels.h"
#include "put_code.h"
#include "procedures.h"


put_thing    current_put;	/* where puts are going */

unsigned pc;			/* offset into current put of next instruction */

/* start put at procedures */

extern int fprintf (FILE *, const char *, ...);

void
init_put(void)
{
	current_put = procedures;
	}

put_thing
make_new_put_thing(unsigned int size)
{
	put_thing tmp;

	tmp = (put_thing)malloc(sizeof(PUT_THING));
	tmp->block_size = size;
	tmp->base = malloc(size);
	tmp->position = tmp->base;
	tmp->limit = (char *)((unsigned)tmp->base + size);
	tmp->dimension = size;

	return(tmp);
	}

void
expand_put_thing(put_thing p)
{
	int off;

	/* store offset since p->position will be meaningless after realloc*/
        off = (int)p->position - (int)p->base;

        p->base = realloc(p->base, (unsigned)
				   (p->dimension += p->block_size)
                          );
	p->limit = (char *)((unsigned)p->base + p->dimension);
	p->position = (char *)((int)p->base + off);
	}

void
put(char c)
{
	if(current_put->position >= current_put->limit)
		expand_put_thing(current_put);
	(*(current_put->position++)) = c;
	}

void 
put_n_bytes(int n, int N)
{
	if(n > 0)
	    {
	    /* put higher bytes */
	    put_n_bytes(--n, N >> 8);
	    /* put lowest byte */
	    put((char)(N & 255));
	    }
	}

void
copy_n_bytes(int n, char *da, char *sa)
          
                   /* source address, destination address */
		   /* assume dest address has been allocated */
	{
	if(n-- > 0)
		{
		*da++ = *sa++;
		copy_n_bytes(n, da, sa);
		}
	}

int
get_offset(char *sa)
{
	char *cp;
	int ret;

	cp = (char *) &ret;

	*cp++ = (char)0;
	*cp++ = (char)0;
	*cp++ = *sa++; 
	*cp = *sa;

	return(ret);
	}

/* rest of routines expect integer arguments */
void 
put_register(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_register(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(REGISTER_SIZE, n);
	}

void 
put_number(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_number(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(NUMBER_SIZE, n);
	}

void 
put_predatom(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_predatom(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(PREDATOM_SIZE, n);
	}

void 
put_offset(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_offset(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(OFFSET_SIZE, n);
	}

void 
put_constant_atom(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_constant_atom(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(CONSTANT_SIZE, n);
	}

void 
put_constant_integer(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_constant_integer(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(CONSTANT_SIZE, Integer(n));
	}

void 
put_constant(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_constant(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(CONSTANT_SIZE, n);
	}

void 
put_address(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_address(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(ADDRESS_SIZE, n);
	}

/* increments pc by size of instruction */
void 
put_instruction(int n)
{
#ifdef EBUG
	fprintf(stderr, "put_instruction(%d)\n",n);
#endif /* EBUG */
	put_n_bytes(INSTRUCTION_SIZE, n);
	pc += size_of_instruction[n];
	}

#define FAIL_OFFSET (-1)
#define FAIL_LABEL "'fail'"

/* put_label_offset(name,	*name of label*
		    pc,		*next inst offset*
		    address)	*offset to store offset*
*/
void
put_label_offset(char *name, int pc, int address)
{
	int place;
#ifdef EBUG
	fprintf(stderr, "put_label_offset(%s,%d,%d)\n",name, pc, address);
#endif /* EBUG */
	if(!strcmp(FAIL_LABEL,name))
		put_offset(FAIL_OFFSET);
	else
	{
	if((place = lookup_label_table(name, address)) >= 0)
	    /* we know to where we're jumping already */
            put_offset(label_table[place].pc - pc);
        else
            /* this position is updated once the label is resolved */
            put_offset(pc);
	}
	}
