/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	PUT_CODE_H
#define	PUT_CODE_H
#include "string_table.h"

typedef struct {
    unsigned 	dimension;
    char	*position;
    char	*limit;
    char	*base;
    unsigned	block_size;
} PUT_THING;

typedef	PUT_THING	*put_thing;

extern put_thing current_put;

extern	unsigned    pc;

void init_put(void);

put_thing make_new_put_thing(unsigned int size);

void expand_put_thing(put_thing p);

void put(char c);

void put_n_bytes(int n, int N);

void copy_n_bytes(int n, char *da, char *sa);

int get_offset(char *sa);

void put_register(int n);

void put_number(int n);

void put_predatom(int n);

void put_offset(int n);

void put_constant_atom(int n);

void put_constant_integer(int n);

void put_constant(int n);

void put_address(int n);

void put_instruction(int n);

#define	CONSTANT_SIZE 	4
#define OFFSET_SIZE	2
#define REGISTER_SIZE	1
#define NUMBER_SIZE	1
#define PREDATOM_SIZE	3
#define ADDRESS_SIZE	4
#define INSTRUCTION_SIZE	1

#endif	/* PUT_CODE_H */
