/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "query_code.h"
#include "procedures.h"
#include "put_code.h"

#include	"string_table.h"
#include	"io.h"

/* STRING_TABLE_BLOCK_SIZE in .h file */
#define LOOKUP_BLOCK_SIZE 32

char 	*string_table;
unsigned current_size; 		/* current size */
unsigned string_table_dim; 	/* dimension of string table */
unsigned *lookup; 		/* table of offsets into the string table */
unsigned lookup_dim; 		/* dimension of lookup table */

void
init_string_table(void)
{
	string_table = malloc((unsigned) STRING_TABLE_BLOCK_SIZE);
	string_table_dim = STRING_TABLE_BLOCK_SIZE;
	current_size = 0;

	lookup_dim = LOOKUP_BLOCK_SIZE;
	lookup = (unsigned *)malloc((unsigned)lookup_dim*sizeof(unsigned));
	lookup[0]=1;	/* since linker will ignore first byte */
	}

void 
expand_lookup(void)
{
	lookup = (unsigned *) realloc(lookup,
				    (unsigned)
				    (lookup_dim += LOOKUP_BLOCK_SIZE)
				    *
				    sizeof(unsigned));
	}

void 
expand_string(void)
{
	string_table = (char *) realloc(string_table,
				      (unsigned)
				      (string_table_dim += STRING_TABLE_BLOCK_SIZE)
				      *
				      sizeof(char));
	}

unsigned
lookup_string_table(char *s)
{
	int	found=0;
	unsigned counter = 0;

	/* lookup[current_size] contains the address of the next free */
	while((counter < current_size)
	      &&
	      (!(found = !strcmp(&string_table[lookup[counter]], s)))
	     )
		counter++;
	/* either no entry and counter at new position
	   or
	   found and counter at current position */

	if(!found)	
		/* make new entry at counter */
		{
		int stringsize;
		stringsize = 1 + strlen(s);
		current_size++;
		/* fix lookup next free position */
		if(lookup_dim == current_size)
			expand_lookup();
		lookup[counter+1] = lookup[counter] + stringsize;

		if(string_table_dim <= lookup[counter+1])
			expand_string();
		strcpy(&string_table[lookup[counter]], s);
		}
	return(counter);
	}


/* write out the string table for query_code and then for procedures */
void
write_string_table(void)
{
	write_integer(lookup[current_size]); 	/* write size */

	/* write string table produced by query code atoms */
	if(lookup[current_size])
	    write_block(string_table, lookup[current_size]);
	}
