/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	STRING_TABLE_H
#define	STRING_TABLE_H

#define STRING_TABLE_BLOCK_SIZE 512
#define MAX_STRING_LENGTH 256

extern    char            *string_table;
extern    unsigned        current_size;           /* current size */
extern    unsigned        string_table_dim;       /* dimension of string table */
extern    unsigned        *lookup;                /* table of offsets
					       into the string table
					     */
extern    unsigned        lookup_dim;        /* dimension of lookup table */

void	init_string_table(void);
unsigned	lookup_string_table(char *s);
void	write_string_table(void);

/* note
	lookup_string_table(s) returns the index n of the string s where
	s is the nth entry in the table
	This CANNOT be accessed by 
	    string_table[n]
*/

#endif	/* STRING_TABLE_H */
