/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * pretrans - Pre-translate clauses to remove shorthand notations.
 */
:- op(700, xfx, \=).

/*----------------------------------------------------------------------------
pretrans(Sentence, NewSentence) :-
    Transform the rhs of Sentence into NewSentence, removing the Qu-Prolog
    shorthand notations.
----------------------------------------------------------------------------*/
pretrans((Head :- Body), (Head :- NewBody)) :-
    !,
    pretrans_formula(Body, NewBody).

pretrans(Sentence, Sentence).

/*----------------------------------------------------------------------------
pretrans_formula(Body, NewBody) :-
    Pre-translate the body of a clause.  Refer to the compiler description
    for full details.
----------------------------------------------------------------------------*/
pretrans_formula(Body, call(Body)) :-
    var(Body), !.
pretrans_formula(X \= Y, ((X = Y, !, fail) ; true)) :-
    !.
pretrans_formula(X \== Y, ((X == Y, !, fail) ; true)) :-
    !.
pretrans_formula(X =\= Y, ((X =:= Y, !, fail) ; true)) :-
    !.
pretrans_formula(\+ (X), ((NewX, !, fail) ; true)) :-
    !,
    pretrans_formula(X, NewX).
pretrans_formula(not(X), ((NewX, !, fail) ; true)) :-
    !,
    pretrans_formula(X, NewX).
pretrans_formula(nonvar(X), ((var(X), !, fail) ; true)) :-
    !.
pretrans_formula(once(X), once(NewX)) :-
    !,
    pretrans_formula(X, NewX).
% pretrans_formula((X -> Y), ((NewX, !, NewY); true)) :-  % NU-Prolog defn
pretrans_formula((X -> Y), ((NewX, !, NewY); fail)) :-  % standard defn
    !,
    pretrans_formula(X, NewX),
    pretrans_formula(Y, NewY).
pretrans_formula((Fs ; OrFs), (NewFs ; NewOrFs)) :-
    var(Fs),
    !,
    pretrans_formula(Fs, NewFs),
    pretrans_formula(OrFs, NewOrFs).
pretrans_formula((Fs ; OrFs), (NewFs ; NewOrFs)) :-
    \+(Fs = (_X -> _Y)),
    !,
    pretrans_formula(Fs, NewFs),
    pretrans_formula(OrFs, NewOrFs).
pretrans_formula((X -> Y; Z), ((NewX, !, NewY); NewZ)) :-
    !,
    pretrans_formula(X, NewX),
    pretrans_formula(Y, NewY),
    pretrans_formula(Z, NewZ).
pretrans_formula((Fs , AndFs), (NewFs , NewAndFs)) :-
    !,
    pretrans_formula(Fs, NewFs),
    pretrans_formula(AndFs, NewAndFs).
pretrans_formula(X, X).
