/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	ARITHMETIC_H
#define	ARITHMETIC_H

#include "defs.h"
#define ArithIntPred1(op) \
			{ \
			return (IsInteger(Xdref(0)) && IsInteger(Xdref(1)) \
				&& (IntOf(X(0)) op IntOf(X(1)))); \
			}

#define ArithInt2(operation) \
			{ \
			VALUE   val;	\
			if (IsInteger(Xdref(0)) && IsInteger(Xdref(1))) \
			{ \
				val.term = Integer(operation); \
				val.sub = EMPTY_SUB; \
				return(unify(XV(2), &val)); \
			} \
			else \
				return(FALSE); \
			}

#define ArithInt1(operation) \
			{ \
			VALUE   val;	\
			if (IsInteger(Xdref(0))) \
			{ \
				val.term = Integer(operation); \
				val.sub = EMPTY_SUB; \
				return(unify(XV(1), &val)); \
			} \
			else \
				return(FALSE); \
			}

#define ArithIntOp2(op)	ArithInt2(IntOf(X(0)) op IntOf(X(1)))
#define ArithIntOp1(op)	ArithInt1(op IntOf(X(0)))

#define ArithIntFn2(fn)	ArithInt2(fn(IntOf(X(0)), IntOf(X(1))))

extern	boolean	esc_times(void);
extern	boolean	esc_divide(void);
extern	boolean	esc_plus(void);
extern	boolean	esc_minus(void);
extern	boolean	esc_mod(void);
extern	boolean	esc_power(void);
extern	boolean	esc_bitwise_and(void);
extern	boolean	esc_bitwise_or(void);
extern	boolean	esc_bitwise_xor(void);
extern	boolean	esc_shift_left(void);
extern	boolean	esc_shift_right(void);
extern	boolean	esc_minus1(void);
extern	boolean	esc_complement(void);
extern	boolean	esc_not(void);
extern	boolean	esc_lt(void);
extern	boolean	esc_leq(void);
extern	boolean	esc_gt(void);
extern	boolean	esc_geq(void);
extern	boolean	esc_less_than(void);

#endif	/* ARITHMETIC_H */
