/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "bind.h"
#include "defs.h"
#include "delayed_problems.h"
#include "errors.h"
#include "trail.h"
#include "name_table.h"


/*----------------------------------------------------------------------------
    var = pointer to the variable to be bound without the REFERENCE tag
    term = any data cell with its data tag
    if the variable is earlier than the last choice point then
	record the variable on the trail
    set the variable to the term
----------------------------------------------------------------------------*/

extern void add_wake_up_problems (cell *problems);

global	void
set(cell *var, cell term)
{

	if (Earlier(var, last_choice_point))
	{
		RecordOnTrail(var, *var);
	}

	*var = term;

}

/*----------------------------------------------------------------------------
    var = pointer to the variable to be bound without the REFERENCE tag
    term = any data cell with its data tag
    wake up the delayed problems associated with the variable
    bind the variable to the term
----------------------------------------------------------------------------*/
global  void
bind_term(cell *var, cell term)
{
	add_wake_up_problems(Location(*var));
	set(var, term);
}

/*----------------------------------------------------------------------------
bind_variable(x, y)
	bind the variable x to y or y to x based on age.
    x y = pointer to the variable to be bound without the REFERENCE tag
----------------------------------------------------------------------------*/
global	void
bind_variable(cell *x, cell *y)
{
	cell	*junior;
	cell	*senior;
	cell	jun;
	

	if (x == Junior(x, y))
	{
		junior = x;
		senior = y;
	}
	else
	{
		junior = y;
		senior = x;
	}

	if (RestOfVariable(*junior) != NULL)
		append_delayed_problems(senior,
					(cell *)RestOfVariable(*junior));

	if (Temperature(*junior) == FREEZE && Temperature(*senior) == THAW)
		set(senior, FREEZE|RestOfTemp(*senior));

        if (senior[1] == NULL) 
	    set(&senior[1], junior[1]); 
	    
	set(junior, Reference(senior));
}

/*----------------------------------------------------------------------------
bind_object_variable(x, y)
	bind the object variable x to y or y to x based on age.
	Wake up delayed problems associated with it and append the
	distinctness information together.
    x y = pointer to the object variable to be bound without the 
	  OBJECT_REFERENCE tag
----------------------------------------------------------------------------*/
global	void
bind_object_variable(cell *x, cell *y)
{
	cell	*junior;
	cell	*senior;
	cell	*d;


	if (x == Junior(x, y))
	{
		junior = x;
		senior = y;
	}
	else
	{
		junior = y;
		senior = x;
	}

	if (RestOfVariable(*junior) != NULL)
	{
		add_wake_up_problems((cell *)RestOfVariable(*junior)); 
	}
	if (RestOfVariable(*senior) != NULL)
		add_wake_up_problems((cell *)RestOfVariable(*senior));
	for (d = &senior[2]; *d != NULL; d = &(((cell *)(*d))[1]))
	;
	set(d, junior[2]);
	if (Temperature(*junior) == FREEZE && Temperature(*senior) == THAW)
		set(senior, FREEZE|RestOfTemp(*senior));

        if (senior[1] == NULL) 
	    set(&senior[1], junior[1]); 

	set(junior, ObjectReference(senior));
}
