/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "cells.h"
#include "code_area.h"
#include "consult.h"
#include "defs.h"
#include "index.h"
#include "link.h"
#include "pc.h"
#include "query_code.h"
#include "resolve_object.h"
#include "string_map.h"
#include "string_table.h"
#include "x_registers.h"

/*----------------------------------------------------------------------------
esc_consult(FileName) :-
    load a compiled object (.qo extension) into the program area
    or load a .ql file into the database.

    load the object file into the program area
    resolve the string offsets and predicate addresses
----------------------------------------------------------------------------*/
global	boolean
esc_consult(void)
{
	index	object_index;
	code	*pc_save;

	if (IsAtom(Xdref(0)))
	{
		pc_save = pc;
		reinitialise_query_code();
		reinitialise_string_map();
		load_object_file(String(X(0)), &object_index);
		link_object(&object_index, 1);
		pc = pc_save;
		return(TRUE);
	}
	else
		return(FALSE);
}
