/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "bind.h"
#include "cells.h"
#include "data_area.h"
#include "dereference.h"
#include "errors.h"
#include "execute.h"
#include "x_registers.h"

global	cell	*heap;
global	natural	heap_size = DEFAULT_HEAP_SIZE;
global	cell	*top_of_heap;

global	cell	*stack;
global	natural	stack_size = DEFAULT_STACK_SIZE;
global	cell	*top_of_stack;
global	cell	*end_of_stack;
global	CHOICE	*last_choice_point;

/*----------------------------------------------------------------------------
low             high
+--------------------------------------+
|delayed stack -> | heap -> | stack -> |
+--------------------------------------+
    allocate a contiguous data area putting the delayed stack in the low, 
    the heap in the middle and the stack in the high end.
----------------------------------------------------------------------------*/
global	void
initialise_data_area(void)
{
        if ((delayed_stack = (delayed *)malloc(Kwords_to_chars(
		    delayed_stack_size + heap_size + stack_size))) == NULL)
             fatal("not enough memory for the delayed stack, heap and stack \
        	  %d, %d and %d K", delayed_stack_size, heap_size, stack_size);
        end_delayed_stack = (delayed *) (((char *)delayed_stack) +
                                      Kwords_to_chars(delayed_stack_size));
	heap = (cell *)(((char *)delayed_stack) +
	               Kwords_to_chars(delayed_stack_size));
	stack = (cell *) (((char *)heap) + Kwords_to_chars(heap_size));
	end_of_stack = (cell *)(((char *)stack) +
				Kwords_to_chars(stack_size));
	last_choice_point = (CHOICE *) stack;

        top_delayed_stack = delayed_stack;
	top_of_heap = heap;
	top_of_stack = stack;
	
}

/*----------------------------------------------------------------------------
	if (no substitution)
		return(term);
	else
		return(create a substitution operator for substitution and
		       term);
----------------------------------------------------------------------------*/
global cell
make_substitution(VALUE *t)
{
	cell	value;

	if (t->sub == EMPTY_SUB)
		return(t->term);
	else
	{
		value = SubstitutionOperator();
		Substitution(value) = t->sub;
		Assign(Term(value), t->term);
		return(value);
	}
}
