/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	DATA_AREA_H
#define	DATA_AREA_H

#include "defs.h"
#include "delayed_problems.h"
#include "persistent.h"
#include "primitives.h"
#include "trail.h"
#include "x_registers.h"

#define	ENV	struct	_ENV
#define	CHOICE	struct	_CHOICE

typedef struct
{
	cell	binding;
	cell	name;
}envcell;

ENV 
{
	ENV	*current_env;
	code	*continuation_instr;
	CHOICE	*continuation_cut;
	natural	num_permanents;
	envcell	y[1];
};

CHOICE
{
	code	*next_clause;
	natural meta_var_extention;
	natural object_var_extention;
	code	*continuation_instr;
	ENV	*current_env;
	CHOICE	*last_choice_point;
	CHOICE	*cut;
	CHOICE	*continuation_cut;
	cell	*top_of_heap;
	trailer	*top_of_trail;
	delayed	*top_delayed_stack;
	int	num_registers;
	VALUE	x[1];
};

#define Y(i)		(current_env->y[i].binding)
#define EnvSize(n) 	((unsigned)(sizeof(ENV) + ((n)-1) * sizeof(envcell)))
#define ChoiceSize(n) 	((unsigned)(sizeof(CHOICE) + ((n)-1) * sizeof(VALUE)))
#define AssignYValue(i, v) (current_env->y[i].binding = (v), \
                            current_env->y[i].name = NULL)
#define AssignYY(i, v) (current_env->y[i].binding = current_env->y[j].binding, \
                        current_env->y[i].name = current_env->y[j].name)

#define EnvirSize(addr) ((char)*((code *)(addr) - SizeOfNumber))
#define InHeap(x)       (heap <= (x) && (x) <= top_of_heap)

/* Position in Stack */

#define Earlier(x,b)	((x) < (b)->top_of_heap ||	\
			 (stack <= (x) && (x) < (cell *)(b)) ||	\
			 InPersistentStack(Reference(x)))

#define CurrentEnvironment(x)	(IsReference(x) && \
				 ((cell *)current_env) < Location(x) && \
				 Location(x) <=  (((cell *)current_env) + \
				 	EnvSize(current_env->num_permanents)))

#define InHeapStack(x)	(heap <= (x) && (x) <= top_of_stack)
#define InLocalStack(x)	(stack <= Location(x) && Location(x) <= top_of_stack)
#define TopOfLocalStack(x,y) (((cell *)(x)) > ((cell *)(y)))
#define	StackAlloc(n)	(((top_of_stack = (cell *)((char *)top_of_stack + \
					    (n))) > end_of_stack) ? \
			    fatal("Out of space in local stack %d K", \
				stack_size) : (void)TRUE)
#define Junior(x,y)	((InHeapStack(x) && !InHeapStack(y)) ? \
				(x) : \
			 (InHeapStack(y) && !InHeapStack(x)) ? \
				(y) : \
			 (x) > (y) ? (x) : (y))


#define DEFAULT_HEAP_SIZE       192
#define DEFAULT_STACK_SIZE      128

extern	cell	*heap;
extern	natural	heap_size;
extern	cell	*top_of_heap;
extern	cell	*stack;
extern	natural	stack_size;
extern	cell	*top_of_stack;
extern	cell	*end_of_stack;
extern	CHOICE	*last_choice_point;
extern	void	initialise_data_area(void);
extern	cell	make_substitution(VALUE *t);

#endif	/* DATA_AREA_H */
