/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	DATABASE_H
#define	DATABASE_H

#include "defs.h"
#include "primitives.h"

#define	DYNAMIC	struct _DYNAMIC

DYNAMIC
{
	offset	functor;
	natural	arity;
	DYNAMIC	*next;
	DYNAMIC	**back_ptr;
	unsigned conceptual_ref_count;	/* no of `pointers' to this struct */
	boolean is_retracted;		/* has this entry been retracted ?*/
	cell	term_space[1];
};

typedef struct
{
	cell	variable;
	cell	reference;
} variable_map;

#define TEMPLATE	20*K
#define	DEFAULT_DATABASE_TABLE_SIZE	10007

#define LocalFlag	0x08000000
#define	HashDynamic(f,n)	((((f) * 167) ^ (n))%database_table_size)
#define	IntToPtr(i)	(init_sbrk + (IntOf(i) << 2))
#define	PtrToInt(p)	(Integer(((char *)(p) - init_sbrk) >> 2))
#define	AllocateDB(n)	(((term_ptr+(n)) > &term_template[TEMPLATE-1] ? \
				fatal("Out of space in term_template in database.c") : \
				(void)TRUE), \
			 term_ptr += (n), \
			 term_ptr-(n))
#define	NewPairDB()	(((term_ptr+2) > &term_template[TEMPLATE-1] ?\
				fatal("Out of space in term_template in database.c") : \
				(void)TRUE), \
			 term_ptr += 2,\
			 (cell)(term_ptr-2))
#define	ApplyDB()	((cell)(APPLY|NewPairDB()))
#define	PairDB()	((cell)(PAIR|NewPairDB()))
#define	QuantifierDB()	((cell)(QUANTIFIER|NewPairDB()))
#define	SubstitutionOperatorDB()  ((cell)(SUBSTITUTION_OPERATOR|NewPairDB()))
#define NewSubstitutionDB(t,n,p)  (((term_ptr+2) > &term_template[TEMPLATE-1] ?\
					fatal("Out of space in term_template in database.c") : \
					(void)TRUE), \
				   *term_ptr++ = (t),  \
				   *term_ptr++ = (n),  \
				   NewProperty(term_ptr-2, p))
#define	SizeDynamic(n)	((unsigned)(sizeof(DYNAMIC) + (n)*sizeof(cell)))

extern	DYNAMIC	**database_table;
extern	natural	database_table_size;
extern	void	initialise_database_table(void);
extern	boolean	esc_asserta(void);
extern	boolean	esc_assertz(void);
extern	boolean	esc_first_clause(void);
extern	boolean	esc_next_clause(void);
extern	boolean	esc_last_clause(void);
extern	boolean	esc_erase(void);
extern	boolean	esc_instance(void);
extern	boolean	esc_instance_no_copy(void);
extern	boolean	esc_static_predicate(void);
extern	boolean esc_first_not_free(void);
extern	boolean	esc_get_not_free(void);
extern	boolean	esc_next_not_free(void);

#endif	/* DATABASE_H */
