/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	DEREFERENCE_H
#define	DEREFERENCE_H

#include "defs.h"
#include "x_registers.h"

#define DereferenceTerm(v, t)	((v).sub = EMPTY_SUB,	\
				 (v).term = (t), 	\
				 dereference(&(v)))
#define VariableDereference(v, t) 	((v) = (t),		\
					 variable_dereference(&(v)))
#define ObjectDereference(v, t)		((v) = (t),		\
					 object_dereference(&(v)))
#define	DerefTerm(v, t)		(DereferenceTerm(v, t), v.term)

extern	void	dereference(VALUE *t);
extern	void	variable_dereference(cell *t);
extern	void	object_dereference(cell *t);
extern	boolean	yield_constant(cell sub, cell constant);
extern	boolean	yield_tag(cell sub, int tag);
extern	boolean	yield_object_variable(cell sub, cell objvar);
extern	boolean	yield_any_object_variable(cell sub);

#endif	/* DEREFERENCE_H */
