/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "arithmetic.h"
#include "build_term.h"
#include "consult.h"
#include "copy_term.h"
#include "database.h"
#include "delayed_problems.h"
#include "escape.h"
#include "examine_term.h"
#include "get_unify_delays.h"
#include "io.h"
#include "ip.h"
#include "object_vars.h"
#include "ops.h"
#include "persistent.h"
#include "read.h"
#include "sig.h"
#include "simplify.h"
#include "spy.h"
#include "write.h"
#include "system.h"
#ifdef X11
#include "events.h"
#include "xwidgets.h"
#endif /* X11 */

global built_in escape_predicate_table[] = {

	/* io */
	{ put,			1,	"put" },
	{ get,			1,	"get" },
	{ put0,			1,	"put0" },
	{ get0,			1,	"get0" },
	{ esc_write_atom,		1,	"$write_atom" },
	{ esc_write_integer,	1,	"$write_integer" },
	{ esc_write_var_name,	1,	"$write_var_name" },
	{ esc_open,		3,	"$open" },
	{ esc_close,		1,	"$close" },
	{ esc_set_input,		1,	"$set_input" },
	{ esc_set_output,		1,	"$set_output" },
	{ flush,		0,	"flush" },
	{ esc_read_term_string,	1,	"$read_term_string" },

	/* write */
	{ esc_writec,		5,	"$writec" },
	{ esc_writeq,		2,	"$writeq" },
	{ esc_writeRc,		3,	"$writeRc" },

	/* read */
	{ esc_readc,		3,	"$readc" },
	{ esc_readRc,		4,	"$readRc" },
	{ esc_readR1c,		3,	"$readR1c" },

	/* build_term */
	{ quantify,	4,	"quantify" },
	{ esc_substitute,	3,	"$substitute" },
	{ esc_new_dynamic_object_var,	1,	"$new_dynamic_object_var" },
	{ esc_new_local,	1,	"$new_local" },

	/* examine_term */
	{ atom,		1,	"atom" },
	{ integer,	1,	"integer" },
	{ var,		1,	"var" },
	{ is_object_var,		1,	"is_object_var" },
	{ esc_is_local_object_var,		1,	"$is_local_object_var" },
	{ atom_chars,		2,	"atom_chars" },
	{ univ,		2,	"univ" },
	{ functor,	3,	"functor" },
	{ arg,		3,	"arg" },
	{ esc_equal,	2,	"$equal" },
	{ esc_var_less_than,	2,	"$var_less_than" },
	{ esc_freeze,	1,	"$freeze" },
	{ esc_thaw,	1,	"$thaw" },
	{ esc_frozen,	1,	"$frozen" },
	{ esc_atoms_to_atom,	2,	"$atoms_to_atom" },
	{ number_chars,	2,	"number_chars" },

	/* system */
	{ get_args,	1,	"get_args" },
	{ esc_getwd,	1,	"$getwd" },
	{ esc_exit,	1,	"$exit" },
	{ statistics,	1,	"statistics" },
	{ esc_write_statistics,	1,	"$write_statistics" },
	{ esc_label,	1,	"$label" },
	{ esc_cut,		1,	"$cut" },
	{ esc_system,	3,	"$system" },
	{ exec,		2,	"exec" },
	{ esc_fork,	0,	"$fork" },
	{ esc_fork3,	3,	"$fork3" },
	{ esc_setFlag,		2,	"$setFlag" },
	{ esc_getFlag,		2,	"$getFlag" },

	/* database */

	/* database */
	{ esc_asserta,		1,	"$asserta" },
	{ esc_assertz,		1,	"$assertz" },
	{ esc_first_clause,	3,	"$first_clause" },
	{ esc_next_clause,		2,	"$next_clause" },
	{ esc_last_clause,		1,	"$last_clause" },
	{ esc_erase,		1,	"$erase" },
	{ esc_instance,		2,	"$instance" },
	{ esc_instance_no_copy,		2,	"$instance_no_copy" },
	{ esc_static_predicate,	3,	"$static_predicate" },
	{ esc_first_not_free,	2,	"$first_not_free" },
	{ esc_get_not_free,	3,	"$get_not_free" },
	{ esc_next_not_free,	2,	"$next_not_free" },

	/* consult */
	{ esc_consult,	1,	"$consult" },

	/* arithmetic */
	{ esc_times,	3,	"$times" },
	{ esc_divide,	3,	"$divide" },
	{ esc_plus,	3,	"$plus" },
	{ esc_minus,	3,	"$minus" },
	{ esc_mod,		3,	"$mod" },
	{ esc_power,	3,	"$power" },
	{ esc_bitwise_and,	3,	"$bitwise_and" },
	{ esc_bitwise_or,	3,	"$bitwise_or" },
	{ esc_bitwise_xor,	3,	"$bitwise_xor" },
	{ esc_shift_left,	3,	"$shift_left" },
	{ esc_shift_right,	3,	"$shift_right" },
	{ esc_minus1,	2,	"$minus1" },
	{ esc_complement,	2,	"$complement" },
	{ esc_not,		2,	"$not" },
	{ esc_lt,		3,	"$lt" },
	{ esc_leq,		3,	"$leq" },
	{ esc_gt,		3,	"$gt" },
	{ esc_geq,		3,	"$geq" },
	{ esc_less_than,	2,	"$less_than" },

	/* delayed problems */

	{ esc_first_delayed_problem,	1,	"$first_delayed_problem" },
	{ esc_get_delayed_problem,		4,	"$get_delayed_problem" },
	{ esc_next_delayed_problem,	2,	"$next_delayed_problem" },
	{ esc_check_delayed_problem,	1,	"$check_delayed_problem" },
	{ retry_delay_problems,		0,	"retry_delay_problems" },

	/* persistent variables */

	{ esc_new_persistent_meta_var,	2,	"$new_persistent_meta_var" },
	{ esc_new_persistent_object_var,	2,	"$new_persistent_object_var" },
	{ esc_persistent_meta_var,	1,	"$persistent_meta_var" },
	{ esc_persistent_object_var,	1,	"$persistent_object_var" },
	{ esc_unpersistent_meta_var,	1,	"$unpersistent_meta_var" },
	{ esc_unpersistent_object_var,	1,	"$unpersistent_object_var" },
	{ is_persistent_var,	1,	"is_persistent_var" },
	{ is_persistent_object_var,	1,	"is_persistent_object_var" },
	{ esc_persistent_name,	2,	"$persistent_name" },

	/* simplification rules */

	{ esc_copy_to_heap,	2,	"$copy_to_heap" },
	{ esc_simplify,	2,	"$simplify" },

	/* object variables */
	{ esc_object_var,	1,	"$object_var" },
	{ esc_object_var_prefix_declared,	1,	"$object_var_prefix_declared" },
	{ esc_object_var_prefix,	1,	"$object_var_prefix" }
	,

	/* operators */
	{ esc_op_,	3,	"$op_" },
	{ esc_first_op,	1,	"$first_op" },
	{ esc_last_op,	1,	"$last_op" },
	{ esc_some_op,	5,	"$some_op" },
	{ esc_next_op,	2,	"$next_op" }
	,

	/* signals */
	{ esc_signal,		2,	"$signal" }
	,
	
	/* ip */
	{ esc_ipsetc,		2,	"$ipsetc" },
	{ esc_iplookupc,		2,	"$iplookupc" },
	
	/* get unify delays */
	{ esc_get_unify_delays,	1,	"$get_unify_delays" },
	{ esc_get_first_unify_delay,	1,	"$get_first_unify_delay" }

};

#ifdef  X11
global built_in escape_x_pred_table[] = {

	{ create_widget,	3,	"create_widget" },
	{ initialize_X,	2,	"initialize_X" },
	{ start_X,	1,	"start_X" },
	{ get_event,	1,	"get_event" },
	{ destroy_widget,	1,	"destroy_widget" },
	{ set_widget_resource,	3,	"set_widget_resource" },
	{ esc_string_read,	1,	"$string_read" },
	{ esc_no_string_read,	0,	"$no_string_read" },
	{ esc_write_to_text_widget,	1,	"$write_to_text_widget" },
	{ esc_close_write_to_text_widget,	0,	"$close_write_to_text_widget" },
	{ text_widget_string,	2,	"text_widget_string" },
	{ clear_text_widget,	3,	"clear_text_widget" },
	{ esc_new_term_write,	0,	"$new_term_write" },
	{ esc_write_done,	0,	"$write_done" },
	{ error_widget,	1,	"error_widget" },
	{ selected_path,	1,	"selected_path" },
	{ selected_widget,	1,	"selected_widget" },
	{ esc_widget_read,	1,	"$widget_read" },
	{ popup_widget,	1,	"popup_widget" },
	{ popdown_widget,	1,	"popdown_widget" },
	{ esc_write_to_term_widget,	1,	"$write_to_term_widget" },
	{ path_to_string,	4,	"path_to_string" },
	{ text_widget_tabs,	2,	"text_widget_tabs" },
	{ install_widget_accelerators,	2,	"install_widget_accelerators" },
	{ set_keyboard_focus_widget,	2,	"set_keyboard_focus_widget" },
	{ esc_string_read_position,	1,	"$string_read_position" },
	{ widget_write_position,	2,	"widget_write_position" },
	{ save_text_widget,	2,	"save_text_widget" }

};
#endif	/* X11 */

#ifdef	EBUG
global built_in escape_debug_pred_table[] = {

/* spy */
	{ esc_add_spy,	2,	"$add_spy" },
	{ esc_list_spied_predicates,	0,	"$list_spied_predicates" },
	{ esc_delete_spy,	2,	"$delete_spy" },
	{ esc_delete_all_spied_predicates,	0,	"$delete_all_spied_predicates" },
	{ esc_trace,	0,	"$trace" },
	{ esc_append,	3,	"$append" }

};
#endif	/* EBUG */

global  boolean
escape_predicate(unsigned int n)
{
	if (n < StartXPred)
		return((*(escape_predicate_table[(n)-1].pred))());
	else if (n < StartDebugPred)
#ifdef  X11
		return((*(escape_x_pred_table[(n)-StartXPred].pred))());
#else
		return(FALSE);
#endif  /* X11 */
	else
#ifdef  EBUG
		return((*(escape_debug_pred_table[(n)-StartDebugPred].pred))());
#else
		return(FALSE);
#endif  /* EBUG */
}

global  char *
escape_name(unsigned int n)
{
	if (n < StartXPred)
		return(escape_predicate_table[(n)-1].name);
	else if (n < StartDebugPred)
#ifdef  X11
		return(escape_x_pred_table[(n)-StartXPred].name);
#else
		return("unknown");
#endif  /* X11 */
	else
#ifdef  EBUG
		return(escape_debug_pred_table[(n)-StartDebugPred].name);
#else
		return("unknown");
#endif  /* EBUG */
}

global  natural
escape_arity(unsigned int n)
{
	if (n < StartXPred)
		return(escape_predicate_table[(n)-1].arity);
	else if (n < StartDebugPred)
#ifdef  X11
		return(escape_x_pred_table[(n)-StartXPred].arity);
#else
		return(0);
#endif  /* X11 */
	else
#ifdef  EBUG
		return(escape_debug_pred_table[(n)-StartDebugPred].arity);
#else
		return(0);
#endif  /* EBUG */
}
