/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	EXAMINE_TERM_H
#define	EXAMINE_TERM_H

#include "defs.h"
#include "primitives.h"

extern	boolean	atom(void);
extern	boolean	integer(void);
extern	boolean	var(void);
extern	boolean	is_object_var(void);
extern	boolean	esc_is_local_object_var(void);
extern	boolean	atom_chars(void);
extern	boolean	esc_atoms_to_atom(void);
extern  cell	get_atom_from_heap(cell value);
extern	boolean	number_chars(void);
extern	boolean	univ(void);
extern	cell	apply(cell fn, cell argument);
extern	cell	build_goal(offset fn, unsigned int arity);
extern	boolean	functor(void);
extern	natural	setup_x_registers(VALUE *goal);
extern	boolean	arg(void);
extern	boolean	esc_equal(void);
extern	boolean	equal(VALUE *term1, VALUE *term2);
extern	boolean	equal_substitution();
extern	boolean	esc_var_less_than(void);
extern	cell	put_string_on_heap(char *s);
extern	cell	replace_term();
extern	char	*get_string_from_heap(cell value);
extern	cell	fetch_functor(cell term);
extern	natural	fetch_arity(cell term);
extern	boolean	esc_freeze(void);
extern	boolean	esc_thaw(void);
extern	boolean	esc_frozen(void);

#endif	/* EXAMINE_TERM_H */
