/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	IO_H
#define	IO_H

#include <stdio.h>
#include "defs.h"

#ifdef X11
#include "xwidgets.h"
#endif /* X11 */

typedef struct
{
	FILE	*strm;
	boolean	end_of_file;
	int in_use;
} QSTREAM;

#define UpperCaseChar(x)        ((x) + 'A')
#define	DEFAULT_NUM_STREAMS	16
#define	QSTDIN			0
#define	QSTDOUT		1
#define	QSTDERR		2
#define	Qstdin	(streams[qstdin].strm)
#define	Qstdout	(streams[qstdout].strm)
#define	InitStream(n,s)	(streams[n].strm = (s), \
			 streams[n].in_use = 1,	\
			 streams[n].end_of_file = FALSE)
#define ClearStream(n)	(streams[n].in_use = 0,	\
			 streams[n].strm = (FILE *)0,	 \
			 streams[n].end_of_file = FALSE )
#define IsClearStream(n)	((!streams[n].in_use) || (!streams[n].strm))
#ifdef	X11
#define	WriteVariableName(p)	{					\
				 if(widget_putting)			\
				 {					\
				   widget_put('_');			\
				   widget_put(UpperCaseChar((p / 17576) % 26));\
				   widget_put(UpperCaseChar((p / 676) % 26));\
				   widget_put(UpperCaseChar((p / 26) % 26));\
				   widget_put(UpperCaseChar(p % 26));	\
				 }					\
				 else					\
				 {					\
				   fprintf(Qstdout, "_%c%c%c%c", 	\
				      UpperCaseChar((p / 17576) % 26), 	\
				      UpperCaseChar((p / 676) % 26), 	\
				      UpperCaseChar((p / 26) % 26), 	\
				      UpperCaseChar(p % 26)); 		\
				     fflush(Qstdout);			\
				 }					\
				}
#define	WriteObjectVariableName(p)					\
				{					\
				 if(widget_putting)			\
				 {					\
				   widget_put('_');			\
				   widget_put('x');			\
				   widget_put(UpperCaseChar((p / 17576) % 26));\
				   widget_put(UpperCaseChar((p / 676) % 26));\
				   widget_put(UpperCaseChar((p / 26) % 26));\
				   widget_put(UpperCaseChar(p % 26));	\
				 }					\
				 else					\
				 {					\
				   fprintf(Qstdout, "_x%c%c%c%c", 	\
				      UpperCaseChar((p / 17576) % 26), 	\
				      UpperCaseChar((p / 676) % 26), 	\
				      UpperCaseChar((p / 26) % 26), 	\
				      UpperCaseChar(p % 26)); 		\
				     fflush(Qstdout);			\
				 }					\
				}
#else
#define	WriteVariableName(p)	{					\
				   fprintf(Qstdout, "_%c%c%c%c", 	\
				      UpperCaseChar((p / 17576) % 26), 	\
				      UpperCaseChar((p / 676) % 26), 	\
				      UpperCaseChar((p / 26) % 26), 	\
				      UpperCaseChar(p % 26)); 		\
				     fflush(Qstdout);			\
				}
#define	WriteObjectVariableName(p)					\
				 {					\
				   fprintf(Qstdout, "_x%c%c%c%c", 	\
				      UpperCaseChar((p / 17576) % 26), 	\
				      UpperCaseChar((p / 676) % 26), 	\
				      UpperCaseChar((p / 26) % 26), 	\
				      UpperCaseChar(p % 26)); 		\
				     fflush(Qstdout);			\
				 }
#endif	/* X11 */


#define	NewFD(a,b)	apply(apply(Atom(add_name_string_offset("$stream",  \
                              ATOM_W)), Integer(a)), Integer(b)); 

#define	Get0()		(feof(Qstdin) ? \
			 	(fatal("attempt to read past end of file in get0"),\
			 	EOF) \
			: \
			 	fgetc(Qstdin))

#define	WhiteSpace(c)	((c) == '\t' || \
			 (c) == '\n' || \
			 (c) == '\f' || \
			 (c) == '\v' || \
			 (c) == '\r' || \
			 (c) == ' ')


extern	boolean	put(void);
extern	void	esc_put(char c);
extern	boolean	get(void);
extern	boolean	put0(void);
extern	boolean	get0(void);
extern	boolean	esc_write_atom(void);
extern	void	esc_write_string(char *s);
extern	boolean	esc_write_integer(void);
extern	void	esc_write_int(int i);
extern	boolean	esc_write_var_name(void);
extern	void	initialise_streams(void);
extern	boolean	esc_open(void);
extern	boolean	esc_close(void);
extern	boolean	esc_set_input(void);
extern	boolean	esc_set_output(void);
extern	boolean	flush(void);
extern	boolean	esc_read_term_string(void);

extern	natural	qstdin;
extern	natural	qstdout;
extern	QSTREAM	*streams;
extern	natural	num_streams;
extern	unsigned char	linebuf[BUFSIZ];
extern	unsigned char	stdinbuf[BUFSIZ];
extern	int		stdinposn,stdinlast;
extern	unsigned char	dynlinebuf[BUFSIZ];

#endif	/* IO_H */
