/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "bind.h"
#include "cells.h"
#include "examine_term.h"
#include "ip.h"
#include "name_table.h"

/*----------------------------------------------------------------------------
$ipsetc(Key, Value)

    If Value is in local stack 
	push a new variable in heap
	set value to new heap variable
        unify value of Key with Value
    else 
        set the value of Key to Value (trail old value).

    Key is an atom or a list of atoms.
    If Key is a list of atoms it is converted to an atom as for the
    functor of ':' operator

----------------------------------------------------------------------------*/

extern int unify (VALUE *t1, VALUE *t2);

global	boolean
esc_ipsetc(void)
{

        cell    atom;
	cell    new_variable;
	VALUE   term;
        boolean result;
	natural i; 

        if (IsList(Xdref(0)))
	{
	       /* convertion list of atoms to an atom */
	    atom =  get_atom_from_heap(X(0));
        }
	else if (IsAtom(X(0)))
	{
	    atom =  X(0);
	}
	else
	    return(FALSE);

    
        if (InLocalStack(Xdref(1)))  
	{
		/* push new_variable in heap */
	    new_variable = NewVariable();
		/* set value of atom to new_variable */
            set(&ValueOfName(name_table[i = lookup_name_table(String(atom),
				                              ATOM_W)]),
	        new_variable);
            term.term = ValueOfName(name_table[i]);
	    term.sub = EMPTY_SUB;
	        /* unify term (ValueOfName(name_table[i])) with XV(1) */
            result = unify(&term, XV(1));
	    return(result);
	}
	else
		/*  set the value of atom to X(1)  */
            set(&ValueOfName(name_table[lookup_name_table(String(atom),
				                          ATOM_W)]),
	        make_substitution(XV(1)));


        return(TRUE);
}


/*----------------------------------------------------------------------------
$iplookupc(Key, Value)

    If value of Key is NULL 
	If Value is an environment variable 
	    push a new variable in heap
	    set value to new heap variable
	    unify value of Key with Value
        else 
	    set value of Key to Value
    else
	unify Value with Key value

    Key is an atom or a list of atoms.
    If Key is a list of atoms it is converted to an atom as for the
    functor of ':' operator

----------------------------------------------------------------------------*/
global	boolean
esc_iplookupc(void)
{

        cell    atom;
	natural i;
        VALUE   term; 
        cell    new_variable;
        boolean result;


        if (IsList(Xdref(0)))
	{
	       /* convertion list of atoms to an atom */
	    atom =  get_atom_from_heap(X(0));
        }
	else if (IsAtom(X(0)))
	{
	    atom =  X(0);
	}
	else
	    return(FALSE);

        i = lookup_name_table(String(atom), ATOM_W);


        if (ValueOfName(name_table[i]) == NULL) 
	{
            if (InLocalStack(Xdref(1))) 
	    {
		     /* push new_variable in heap */
	         new_variable = NewVariable();
		     /* set value of atom to new_variable */
                 set(&ValueOfName(name_table[i]), new_variable); 
	         term.term = ValueOfName(name_table[i]); 
	         term.sub = EMPTY_SUB;
		     /* unify term (ValueOfName(name_table[i])) with XV(1) */
	         result = unify(&term, XV(1));
	         return(result);
	    }
	    else
            {
		     /* set value of atom to X(1) */  
	         set(&ValueOfName(name_table[i]), X(1));
                 return(TRUE);
             }
         } 
	 else
	 {
	     term.term = ValueOfName(name_table[i]);
	     term.sub = EMPTY_SUB;
		 /* unify term (ValueOfName(name_table[i])) with XV(1) */
	     result = unify(&term, XV(1));
             return(result);
         }  
}
