/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef READ_H
#define	READ_H

extern	boolean	esc_readc(void);
extern	boolean	esc_readRc(void);
extern	boolean	esc_readR1c(void);

#define	Fflush(file)	(fflush(file), (file)->_cnt = 0)

#define	SKIP_WHITE_SPACE	TRUE
#define	NO_SKIP_WHITE_SPACE	FALSE

#define	HashVariable(variable_type,tok) \
	hash_variable((variable_type), \
	    add_name_string_offset((tok)->buff, ATOM_W), (cell)NULL);
#define IsAnonymousObjectVariable(s)	(IsAnonymous(s) && chtype((s)[1]) == lower)
#define IsAnonymous(s)	((s)[0] == '_')

#define READ_ORD            0
#define READ_R              1
#define READ_R1             2
extern char *string_read_pos; 
extern char *string_read_base;
extern char *last_string_base;
extern int string_read;

extern boolean esc_string_read(void);
extern boolean esc_no_string_read(void);
extern boolean esc_string_read_position(void);

#endif	/* READ_H */
