#include <signal.h>
#include <setjmp.h>
#include "queue.h"
#include "x_registers.h"
#include "examine_term.h"
#include "cells.h"
#include "string_table.h"


#define NUM_SIGNALS 32

static queue sigs;
static char * sig_to_predicate[NUM_SIGNALS];
static boolean delaying_handling = 1;
global jmp_buf signaljump;

void
init_signals(void)
{
    int i;
    sigs = new_q(30);
    for(i = 0; i < NUM_SIGNALS; i++){
	sig_to_predicate[i] = (char *)0;
    }
}

global boolean
esc_signal(void)
 /* Declares pred as the signal handler for sig. */
 /* if sig is variable the default action is reinstated */
 /* When sig is generated, the emulator waits until the next call, then calls 
  * pred (a predicate of arity 1), to which it passes a list the form 
  * of which is as yet undecided but will be signal dependent.
  */
{
	int sig;
	if(IsInteger(Xdref(0)) 
	&& (sig = IntOf(X(0))) < NUM_SIGNALS) { 
		if(IsAtom(Xdref(1))){ 
		  local void interrupt_handler(int sig, int code, struct sigcontext *scp, char *addr);
	           sig_to_predicate[sig] = String(X(1));
		   signal(sig, interrupt_handler);
	           return(TRUE);
		} else 
		if(IsReference(X(1))){
		   sig_to_predicate[sig] = (char *)0;
		   signal(sig, SIG_DFL);
		   return(TRUE);
		}
	}
	return(FALSE);
}

local void
interrupt_handler(int sig, int code, struct sigcontext *scp, char *addr)
{
	mjoin_q(sigs, 4, sig, code, scp, addr);
	if(!delaying_handling)
	    longjmp(signaljump, sig);
}

global boolean
is_signal(void)
{
    return(!q_empty(sigs));
}



global void
delay_signal_handling(void)
{
    delaying_handling = 1;
}

global void
no_delay_signal_handling(void)
{
    delaying_handling = 0;
}

/* builds arg list for interrupt predicate */
   /*
    * returns offset of $handle_signals/1
    */
global offset
get_signal_handler(void)
{
    int sig, c;
    struct sigcontext *scp;
    char *addr;
    static cell build_handler_list();

    X(0) = build_handler_list();
    XS(0) = EMPTY_SUB;
    return(add_name_string_offset("$handle_signals", ATOM_W));
}

static cell 
build_handler_list(void)
{
    int sig, c;
    struct sigcontext *scp;
    char *addr;
    if(!q_empty(sigs)){
	mserve_q(sigs, 4, &sig, &c, &scp, &addr);
	return(Cons( apply(  Atom(add_name_string_offset(
					sig_to_predicate[sig], 
					ATOM_W)),
		             Cons(Integer(sig),
			          Cons(Integer(c),
				       Cons(Integer((int)scp),
				            Cons(Integer((int)addr),
					         Atom(NIL)))))),
		     build_handler_list()));
    } else
	return(Atom(NIL));
}
