/*--------------------------------------------------------------------
  simplify.h   -     simplify the term   
                     There is a collection of macros that build terms 
                     on the stack - scratch_pad.
                     Stack overflow is tested.

 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.

  Revision History:
  =================

  Version  DD/MM/YY   Author   Description
  -------  --------   ------   ----------------------------------------
   1.0       /07/92     SZ      simplify the term  

--------------------------------------------------------------------*/

#ifndef SIMPLIFY_H
#define	SIMPLIFY_H

#include "cells.h" 
#include "defs.h"
#include "execute.h"
#include "primitives.h"

/*
 * Support Macroes
 */

#define ScratchPadCheck(n)      ((top_scratch_pad+(n)) > end_scratch_pad ?    \
                          fatal("Out of scratch_pad %d K", scratch_pad_size) :\
                                        (void)TRUE)
/*
 * Creation 
 */ 

#define ApplySP()               ((cell)(APPLY|NewPairSP()))

#define NewPairSP()             (ScratchPadCheck(6),                          \
                                 *top_scratch_pad=Reference(top_scratch_pad+2),\
                                 top_scratch_pad++ ,                           \
                                 *top_scratch_pad=Reference(top_scratch_pad+3),\
                                 top_scratch_pad++ ,                           \
                                 *top_scratch_pad++ = NULL_VARIABLE,        \
                                 *top_scratch_pad++ = NULL,                 \
                                 *top_scratch_pad++ = NULL_VARIABLE,        \
                                 *top_scratch_pad++ = NULL,                 \
                                 (cell)(top_scratch_pad-6))

#define SubOperatorSP()         ((cell)(SUBSTITUTION_OPERATOR|NewPairSP()))
#define QuantifierSP()          ((cell)(QUANTIFIER|NewPairSP()))
#define AllocateSP(n)           (ScratchPadCheck(n),          \
                                 top_scratch_pad += (n),    \
                                 (top_scratch_pad-(n)))

#define NewSubSP(t,n,p)         (ScratchPadCheck(2),          \
                                 *top_scratch_pad++ = (t),  \
                                 *top_scratch_pad++ = (n),  \
                                 NewProperty(top_scratch_pad-2, p))

/*
 * Other accesses
 */

#define SizeSP(s)                 (((cell *)(s))[0])
#define DomainSP(s,n)             ((s)[2 * n - 1])
#define RangeSP(s,n)              ((s)[2 * n])

#define DEFAULT_SCRATCH_PAD_SIZE  500

#define NO_RULE                   0
#define RULE_1                    1
#define RULE_1_TERMINATE          2
#define COPY_SUB                  3

extern      cell        *scratch_pad;
extern      cell        *end_scratch_pad;
extern      cell        *top_scratch_pad;


extern	boolean	esc_simplify(void);
extern	cell	simp(VALUE *term);
extern	void	initialise_scratch_pad(void);
#endif	/* SIMPLIFY_H */
