
/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifdef EBUG

#include "cells.h"
#include "spy.h"
#include "sig.h"
#include "string_table.h"
#include "x_registers.h"
#include <string.h>

#define SPY_BLOCK_SIZE 100

global	predicate *spied_predicates;

global	natural	spied_predicate_table_size = 0;	/* no. of predicates spied */

global	natural	spied_predicate_table_dim = 0;	/* physical size of table */

global int qwerty = 0;
global boolean debug_retry = FALSE;

/**********************************************************************
global void initialise_spied_predicates()
    This should be called before any use of the table is made.
----------------------------------------------------------------*/

extern int fprintf (FILE *, const char *, ...);

global void
initialise_spied_predicates(void)
{
	spied_predicate_table_size = 0;
	spied_predicate_table_dim = spied_predicate_table_size + 1;
	spied_predicates = (predicate *) malloc((unsigned)
			(spied_predicate_table_dim * sizeof(predicate)));

	spied_predicates[0].functor = "$$all";
	spied_predicates[0].arity = 0;
}

/**********************************************************************
void extend_spied_predicates_table(d)
    Extend the spied predicates table by `d' predicates.
    * variable spied_predicate_table_dim is increased by `d'
---------------------------------------------------------------------*/
void 
extend_spied_predicate_table(unsigned int d)
{
	spied_predicate_table_dim += d;
	if(!(
	    spied_predicates 
	    = (predicate *)
	      realloc((char *)spied_predicates, 
		      (unsigned)(spied_predicate_table_dim*sizeof(predicate))
		     )
	  ))
	  fatal("Cannot realloc spied predicates table\n");
	}


/**********************************************************************
predicate * next_spied_position()
    Return the next free position in the spied predicates table.
    *side effects
	*if table is full table is `realloc'ed and value of
	 spied_predicate_table_size is reassigned.
	*value of spied_predicate_table_size is incremented.
---------------------------------------------------------------------*/
predicate *
next_spied_position(void)
{
	if((spied_predicate_table_size+1) > spied_predicate_table_dim)
		extend_spied_predicate_table(SPY_BLOCK_SIZE);
	return &(spied_predicates[spied_predicate_table_size]);
	}

global boolean
esc_trace(void)
{
	predicate *pp;

	pp = next_spied_position();
	spied_predicate_table_size++;
	(*pp).functor= ALL;
	(*pp).arity = 0;
	return(TRUE);
}

/**********************************************************************
global	void $add_spy(functor, arity)
    This is an escape function.
    Add an entry to the spied_predicates table.
---------------------------------------------------------------------*/

global	boolean
esc_add_spy(void)
{
	predicate *pp;
	char 	*functor;
	natural	arity;
	int 	i=0,found=0;
             
	/* initialise vars */
	functor = String(Xdref(0));
	arity = RestOfConstant(Xdref(1));

	if(!strcmp(functor, "crash"))
		fatal("well you asked me to do it");
	/* step through table trying to match functor and arity */
	
#ifdef	X11
	if (!strcmp(functor, "hierarchy"))
	    write_widget_hierarchy();
#endif	/* X11 */
	if (!strcmp(functor, "debug_retry"))
	    debug_retry = TRUE;
	if (!strcmp(functor, "qwerty"))
	    qwerty = 1;
	while(i < spied_predicate_table_size && !found)
		{
		found = (!strcmp(functor, spied_predicates[i].functor) &&
		    	arity == spied_predicates[i].arity);
		if(!found) i++;
		}
	/* if in the table - succeed */
	if(found) return(TRUE);

	/* otherwise add to the table */
	pp = next_spied_position();
	spied_predicate_table_size++;
	(*pp).functor = functor;
	(*pp).arity = arity;
	return(TRUE);
	}


/**********************************************************************
global	boolean list_spied_predicates()
    This is an escape function.
    List the entries in the spied_predicates table.
---------------------------------------------------------------------*/
global	boolean
esc_list_spied_predicates(void)
{
	int i;
	for(i = 0; i < spied_predicate_table_size; i++)
	    fprintf(stdout, "%s/%d\n", 
		    spied_predicates[i].functor, 
		    spied_predicates[i].arity
		   );
	return(TRUE);
	}

/**********************************************************************
global	boolean delete_spy()
    This is an escape function.
    Delete an entry from the spied predicate table.
---------------------------------------------------------------------*/
global	boolean
esc_delete_spy(void)
{
	natural	i=0,j=0;	/* indexes to the table */
	char *functor;		/* the functor to be deleted */
	int arity;		/* its arity */
	int found = 0;		/* true when functor has been located */

	/* initialise vars */
	functor = String(Xdref(0));
	arity = RestOfConstant(Xdref(1));

	if (!strcmp(functor, "debug_retry"))
	    debug_retry = FALSE;
	/* step through table trying to match functor and arity */
	while(i < spied_predicate_table_size && !found)
		{
		found = (!strcmp(functor, spied_predicates[i].functor) &&
		    	arity == spied_predicates[i].arity);
		if(!found) i++;
		}
	/* if not in the table - fail */
	if(!found) return(FALSE);

	/* i is the index of the found spied-on-predicate */
	/* drop the table above i by one */
	for(j = i; j < spied_predicate_table_size - 1; j++)
		{
		spied_predicates[j].functor = spied_predicates[j+1].functor;
		spied_predicates[j].arity = spied_predicates[j+1].arity;
		}
	spied_predicate_table_size--;
	/* indicate success */
	return(TRUE);
	}

/**********************************************************************
global	boolean delete_all_spied_predicates()
    This is an escape function.
    Delete all entries from the spied predicate table.
---------------------------------------------------------------------*/
global	boolean
esc_delete_all_spied_predicates(void)
{
	spied_predicate_table_size = 0;
	return(TRUE);
	}

#endif /* EBUG */
