/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	SUBSTITUTION_H
#define	SUBSTITUTION_H

#include "cells.h"
#include "defs.h"
#include "primitives.h"

#define	Invertible(s)		(Property(s) == INVERTIBLE)
#define	ObjectVariablesOnly(s)	(Property(s) == OBJECT_VARIABLES_ONLY)
#define	Others(s)		(Property(s) == OTHERS)
#define ContainLocal(s, i)	(IsLocalObjectVariable(Domain((s), (i))) || \
				 IsLocalObjectVariable(Range((s), (i))))

extern	int	determine_property(cell sub);
extern	boolean	invert(cell sub, VALUE *t);
extern	cell	add_substitution(cell front, cell back);
extern	cell	copy_substitution(cell sub, cell stop_point);
extern	boolean	in_range(cell objvar, cell sub);
extern	boolean	in_domain(cell objvar, cell sub);
extern	boolean	in_all_domain(cell objvar, cell sub);
extern	boolean	same_domain(cell sub1, cell sub2);

#endif	/* SUBSTITUTION_H */
