/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	SYSTEM_H
#define	SYSTEM_H

#include "defs.h"
#include "examine_term.h"

#define	QUFLAG	struct	_QUFLAG

QUFLAG
{
	cell	name;
	cell	state;
};

#define Hz 60
#define CWD_SIZE	64
#define	FLAG_NUMBER	32

#define	Group(a,b,c)   apply(apply(Atom(add_name_string_offset("=", ATOM_W)),  \
		         	   Atom(add_name_string_offset(#a, ATOM_W))), \
			     Cons(Integer(b), Cons(Integer(c), Atom(NIL))))


extern	boolean	get_args(void);
extern	boolean	esc_getwd(void);
extern	boolean	esc_exit(void);
extern	boolean	statistics(void);
extern	boolean	esc_write_time(void);
extern	boolean	esc_write_statistics(void);
extern	boolean	esc_label(void);
extern	boolean	esc_cut(void);
extern	boolean	esc_system(void);
extern	boolean	exec(void);
extern	boolean	esc_fork(void);
extern	boolean	esc_fork3(void);
extern	boolean	length(VALUE *list, unsigned int *n);
extern	boolean	esc_setFlag(void);
extern	boolean	esc_getFlag(void);
extern	cell	flag_value(int name);
extern	void	init_flags(void);

#endif	/* SYSTEM_H */
