/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "defs.h"
#include "errors.h"
#include "trail.h"

global	trailer	*trail;
global	natural	trail_size = DEFAULT_TRAIL_SIZE;
global	trailer	*top_of_trail;
global	trailer	*end_of_trail;

/*----------------------------------------------------------------------------
    allocate memory for the trail, setting the top of trail to the start.
----------------------------------------------------------------------------*/
global	void
initialise_trail(void)
{
	if ((trail = (trailer *) malloc(Kwords_to_chars(trail_size))) == NULL)
		fatal("not enough memory for the trail %d K", trail_size);
	end_of_trail = (trailer *) (((char *)trail) +
				      Kwords_to_chars(trail_size));
	top_of_trail = trail;
}
