/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	TRAIL_H
#define	TRAIL_H

#include "defs.h"
#include "primitives.h"

typedef struct
{
	cell	*address;
	cell	previous_value;
} trailer;

#define RecordOnTrail(a,v)	if (top_of_trail+1 <= end_of_trail)	\
				{					\
					top_of_trail->address = (a);	\
					top_of_trail->previous_value = (v); \
					top_of_trail++;			\
				}					\
				else					\
				     fatal("out of trail space %d K",	\
					trail_size)

#define DEFAULT_TRAIL_SIZE      64

extern	trailer	*trail;
extern	natural	trail_size;
extern	trailer	*top_of_trail;
extern	trailer	*end_of_trail;
extern	void	initialise_trail(void);

#endif	/* TRAIL_H */
