/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	X_REGISTERS_H
#define	X_REGISTERS_H

#include "defs.h"
#include "primitives.h"

typedef struct
{
	cell	sub;
	cell	term;
} VALUE;

#define	X(i)	(x[i].term)
#define	XS(i)	(x[i].sub)
#define	XV(i)	(&x[i])
#define Xdref(i) (dereference(XV(i)), X(i))
#define	InitXV(i)	(X(i) = (cell) NULL, XS(i) = EMPTY_SUB) 


#define DEFAULT_NUM_X_REGISTERS 20

extern	VALUE	*x;
extern	natural	num_x_registers;
extern	void	initialise_x_registers(void);

#endif	/* X_REGISTERS_H */
