/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

write_delayed_problems_as_constraints :-
    '$first_delayed_problem'(_),
    !,
    nl, nl,
    indent, write('provided:'),
    '$write_delayed_problems'.
write_delayed_problems_as_constraints.

write_delayed_problems :-
    set_indent(0),
    '$write_delayed_problems'.

'$write_delayed_problems' :-
    '$first_delayed_problem'(Ref),
    setFlag(localfix, on, Old),
    write_delayed_problem(Ref),
    setFlag(localfix, Old, _).
'$write_delayed_problems'.
 
write_delayed_problem(Ref) :-
    '$get_delayed_problem'(Ref, Type, Left, Right),
    nl, indent,
    write(Left), write(' '), write(Type), write(' '), write(Right), write(' '),
    '$next_delayed_problem'(Ref, NextRef),
    write_delayed_problem(NextRef).

get_unify_delays(X) :- '$get_unify_delays'(X).
get_first_unify_delay(X) :- '$get_first_unify_delay'(X).

widget_write_delayed_problems(Widget) :-
    '$write_to_text_widget'(Widget),
    '$write_delayed_problems',
    '$close_write_to_text_widget'.
