/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

fail:-
	fail.

exit(T) :-
    '$exit'(T).

absolute_file_name('.', D) :-
    !,
    '$getwd'(D).
absolute_file_name(_, _) :-
    writeln('absolute_file_name/2: not fully implemented yet'),
    fail.

F =.. Args :-
    univ(F, Args).

X = X.

X == Y :-
    '$equal'(X, Y).

X =:= Y :-
    X1 is X,
    Y1 is Y,
    X1 == Y1.

\+ X :-
    \+ X.

nonvar(X) :-
    \+ var(X).

X -> Y :-
    (X, !, Y)
    ;
    fail.

once(P) :- P, !.

isList([]).
isList([_|_]).

member(X, [X|_T]).
member(X, [_Y|T]) :- member(X, T).

length(L, N) :- length2(L, N), !.

length2([], 0).
length2([_H|T], N) :- length2(T, M), N is M + 1.

append([], X, X).
append([H|A], B, [H|C]) :- append(A, B, C).

delete(X, [X|L], L).
delete(X, [Y|L1], [Y|L2]):- delete(X, L1, L2).

merge([], L, L):- !.
merge(L, [], L):- !.
merge([X|L1], [Y|L2], L3):- X == Y, !, merge(L1, [Y|L2], L3). 
merge([X|L1], [Y|L2], [X|L3]):- X @< Y, !, merge(L1, [Y|L2], L3). 
merge(L1, [Y|L2], [Y|L3]):- merge(L1, L2, L3). 


reverse([], []).
reverse([H|X], Z) :- reverse(X, Y), append(Y, [H], Z).

true.

repeat.
repeat :- repeat.

atomic(Term) :-
    atom(Term).
atomic(Term) :-
    integer(Term).

name(Atom, List) :-
	(   integer(Atom)
	;
	    nonvar(List),
	    all_num(List)
	),
	!,
	number_chars(Atom, List).
name(Atom, List) :-
	atom_chars(Atom, List).

all_num([]).
all_num([X|L]) :-
	48 =< X,
	X =< 57,
	all_num(L).

unix(argv(Args)) :-
	get_args(Args).
unix(exit(N)) :-
	'$exit'(N).

/*
sort
bagof
setof
findall
see ~/News/bagof_setof
*/
