/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

:- op(1200, xfx, (:-)).
:- op(1200, xfx, (-->)).
:- op(1200, fx, (?-)).
:- op(1200, fx, (:-)).
:- op(1100, xfy, (;)).
:- op(1050, xfy, (->)).
:- op(1000, xfy, (',')).
:- op(900, xfx, (:)).
:- op(900, fy, spy).
:- op(900, fy, once).
:- op(900, fy, not).
:- op(900, fy, nospy).
:- op(900, fy, listing).
:- op(900, fy, (dynamic)).
:- op(900, fy, \+).
:- op(700, xfx, is).
:- op(700, xfx, \==).
:- op(700, xfx, \=).
:- op(700, xfx, @>=).
:- op(700, xfx, @=<).
:- op(700, xfx, @>).
:- op(700, xfx, @<).
:- op(700, xfx, >=).
:- op(700, xfx, >).
:- op(700, xfx, =\=).
:- op(700, xfx, ==).
:- op(700, xfx, =<).
:- op(700, xfx, =:=).
:- op(700, xfx, =..).
:- op(700, xfx, =).
:- op(700, xfx, <).
:- op(700, xfx, distinct_from).
:- op(600, xfy, '.').
:- op(600, xfy, not_free_in).
:- op(500, yfx, \/).
:- op(500, yfx, /\).
:- op(500, yfx, -).
:- op(500, yfx, +).
:- op(500, fx, \).
:- op(500, fx, (-)).
:- op(500, fx, (+)).
:- op(400, yfx, >>).
:- op(400, yfx, <<).
:- op(400, yfx, //).
:- op(400, yfx, /).
:- op(400, xfy, *).
:- op(300, xfx, mod).
:- op(300, xfy, **).
:- op(100, fx, #).
:- op(100, fx, @).

/*----------------------------------------------------------------------------
op(Precedence, Associativity, Op) :-
    Declares Op, an atom or a list of atoms, to be an operator with
    specified Associativity and Precedence. Is is possible to declare Op as
    only one unary and/or binary operator. If Op is declared as both unary
    and binary, both must have the same precedence.

    Precedence	in range <1 ... 1200>
    Associativity
		unary
			postfix	xf; yf
			prefix	fx; fy
		binary
			infix	xfx; xfy; yfx; yfy
			prefix	fxx; fxy; fyx; fyy
			postfix	NOT ALLOWED -> leads to ambiguities
    If unary and binary then same precedence.
			
    Any new definition for an Op will replace the a current definition for
    that Precedence.

----------------------------------------------------------------------------*/
op(Precedence, Associativity, Op) :-
    integer(Precedence),
    atom(Associativity),
    Precedence >= 1,
    Precedence =< 1200,
    ('$isAssoc'(Associativity,N) ->
	'$op_'(Precedence, N, Op)
    ;
	fail
    ).


/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
    
'$isAssoc'(Associativity,N) :-
    '$unary_prefix'(Associativity,N).
'$isAssoc'(Associativity,N) :-
    '$unary_postfix'(Associativity,N).
/*
'$isAssoc'(Associativity,N) :-
    '$binary_prefix'(Associativity,N).
*/
'$isAssoc'(Associativity,N) :-
    '$binary_infix'(Associativity,N).
'$isAssoc'(quant,8).

'$unary'(Associativity,N) :-
    '$unary_prefix'(Associativity,N).
'$unary'(Associativity,N) :-
    '$unary_postfix'(Associativity,N).

'$binary'(Associativity,N) :-
    '$binary_infix'(Associativity,N).
'$binary'(Associativity,N) :-
    '$binary_postfix'(Associativity,N).

'$unary_prefix'(fx,0).
'$unary_prefix'(fy,1).

'$unary_postfix'(xf,2).
'$unary_postfix'(yf,3).

'$binary_infix'(xfx,4).
'$binary_infix'(xfy,5).
'$binary_infix'(yfx,6).
'$binary_infix'(yfy,7).

current_op(Precedence, Associativity, Op) :-
	'$isAssoc'(Associativity,N),
	'$currentOp'(Precedence, N, Op).

'$currentOp'(Precedence, N, Op) :-
	'$first_op'(Ref),
	'$op_ref2'(Ref, Precedence, N, Op).

'$op_ref2'(Ref, Precedence, N, Op) :-
	'$last_op'(Ref),
	!,
	'$some_op1'(Ref, Precedence, N, Op).
'$op_ref2'(Ref, Precedence, N, Op) :-
	atom(Op),
	!,
	'$some_op1'(Ref2, Precedence, N, Op).
'$op_ref2'(Ref, Precedence, N, Op) :-
	'$some_op1'(Ref, Precedence, N, Op).
'$op_ref2'(Ref, Precedence, N, Op) :-
	'$next_op'(Ref, NextRef),
	'$op_ref2'(NextRef, Precedence, N, Op).

'$some_op1'(Ref, Precedence, N, Op) :-
	'$some_op'(Ref, Precedence, N, Op, 1).
'$some_op1'(Ref, Precedence, N, Op) :-
	'$some_op'(Ref, Precedence, N, Op, 2).
