/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

persistent(Term) :-
    '$collect_variables'(Term, var, [], Vars),
    '$persistent'(Vars).

'$persistent'([]).
'$persistent'([X|Vars]) :-
    var(X),
    !,
    '$persistent_meta_var'(X),
    '$persistent'(Vars).
'$persistent'([X|Vars]) :-
    is_object_var(X),
    !,
    '$persistent_object_var'(X),
    '$persistent'(Vars).
'$persistent'([_X|Vars]) :-
    '$persistent'(Vars).

unpersistent(Term) :-
    '$collect_variables'(Term, var, [], Vars),
    '$unpersistent'(Vars).

'$unpersistent'([]).
'$unpersistent'([X|Vars]) :-
    var(X),
    !,
    '$unpersistent_meta_var'(X),  /* X# points to X */
    '$unpersistent'(Vars).
'$unpersistent'([X|Vars]) :-
    is_object_var(X),
    !,
    '$unpersistent_object_var'(X),  /* x# points to x */
    '$unpersistent'(Vars).
'$unpersistent'([_X|Vars]) :-
    '$unpersistent'(Vars).
