/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

old_portraycl(Clause) :-
    '$simplify'(Clause, Simplified),
    '$old_portraycl'(Simplified),
    fail.
old_portraycl(_).

term_widget_old_portraycl(Widget, Clause) :-
    '$write_to_term_widget'(Widget),
    widget_old_portraycl(Widget, Clause).

widget_old_portraycl(Widget, Clause) :-
    '$write_to_text_widget'(Widget),
    old_portraycl(Clause),
    '$close_write_to_text_widget'.

'$old_portraycl'((Head :- Body)) :-
    nonvar(Head),
    !,
    '$initialise_for_renaming',
    '$old_portrayterm'(Head, [], Renames),
    '$old_portrayterm3'(' :-', _, _, _),
    put(10),		% newline
    '$rhs_list'(Body, Goals),
    '$old_portraygoals'(Goals, Renames, _Renames2),
    '$clean_up_after_renaming'.
'$old_portraycl'(Head) :-
    '$initialise_for_renaming',
    '$old_portrayterm'(Head, [], _Renames),
    '$clean_up_after_renaming'.

old_portraygoals(Goals) :-
    '$initialise_for_renaming',
    '$old_portraygoals'(Goals, [], _Renames),
    '$clean_up_after_renaming'.

term_widget_old_portraygoals(Widget, Goals) :-
    '$write_to_term_widget'(Widget),
    widget_old_portraygoals(Widget, Goals).

widget_old_portraygoals(Widget, Goals) :-
    '$write_to_text_widget'(Widget),
    old_portraygoals(Goals),
    '$close_write_to_text_widget'.

'$old_portraygoals'([], Renames, Renames).
'$old_portraygoals'([Goal, Goal2|Goals], Renames, Renames3) :-
    !,
    put(0'	),	% TAB
    '$old_portrayterm'(Goal, Renames, Renames2),
    put(0',),
    put(10),		% newline
    '$old_portraygoals'([Goal2|Goals], Renames2, Renames3).
'$old_portraygoals'([Goal|Goals], Renames, Renames3) :-
    put(0'	),	% TAB
    '$old_portrayterm'(Goal, Renames, Renames2),
    '$old_portraygoals'(Goals, Renames2, Renames3).

old_portrayterm(Term) :-
    '$simplify'(Term, Simplified),
    '$old_portrayterm'(Simplified),
    fail.
old_portrayterm(_).

term_widget_old_portrayterm(Widget, Term) :-
	'$write_to_term_widget'(Widget),
	widget_old_portrayterm(Widget, Term).

widget_old_portrayterm(Widget, Term) :-
	'$write_to_text_widget'(Widget),
	old_portrayterm(Term),
	'$close_write_to_text_widget'.

'$old_portrayterm'(Term) :-
    '$initialise_for_renaming',
    '$old_portrayterm'(Term, [], _Renames),
    '$clean_up_after_renaming'.

'$old_portrayterm'(Term, Renames, Renames2) :-
    setFlag(localfix, on, Old),
    '$old_portrayterm2'(Term, Renames, Renames2, 1200, complete),
    setFlag(localfix, Old, _).

'$old_portrayterm2'(SubTerm, Renames, Renames3, Precedence, CompleteStatus) :-
    (CompleteStatus == complete -> '$new_term_write' ; true),
    substitute(SubTerm, Subs, Term),
    current_op(SubPred, xfy, *),
    (Subs \== [], SubPred >= Precedence -> put(0'() ; true),
    '$old_portray_subs'(Subs, Renames, Renames2),
    (Subs == [] ->
        Precedence1 = Precedence
    ;
        Precedence1 = SubPred
    ),
    '$old_portrayterm3'(Term, Renames2, Renames3, Precedence1),
    (Subs \== [], SubPred >= Precedence -> put(0')) ; true),
    (CompleteStatus == complete -> '$write_done' ; true).

'$old_portray_subs'([], Renames, Renames).
'$old_portray_subs'([S|Subs], Renames, Renames3) :-
    put(0'[),
    current_op(Precedence, yfx, '/'),
    '$old_portray_sub'(S, Renames, Renames2, Precedence),
    put(0']),
    put(0'*),
    '$old_portray_subs'(Subs, Renames2, Renames3).

'$old_portray_sub'([T/X|S], Renames, Renames4, Precedence):-
    '$old_portrayterm2'(T, Renames, Renames2, Precedence, complete),
    put(0'/),
    '$old_portrayterm3'(X, Renames2, Renames3, Precedence),
    (S \== [] ->
	put(0',), put(0' ),
	'$old_portray_sub'(S, Renames3, Renames4, Precedence)
    ;
	Renames4 = Renames3
    ).

'$old_portrayterm3'(Term, Renames, Renames, _Precedence) :-
    is_persistent_var(Term), !,
    '$persistent_name'(Term, Name),
    put(0' ),
    put(0'#),
    '$write_atom'(Name).
'$old_portrayterm3'(Term, Renames, Renames2, _Precedence) :-
    var(Term), !,
    '$old_portray_var'(Term, Renames, Renames2).
'$old_portrayterm3'(Term, Renames, Renames, _Precedence) :-
    '$is_local_object_var'(Term),
    '$object_var_prefix'(Objvar), !,
    put(0'@),
    '$write_atom'(Objvar),
    '$write_var_name'(Term).
'$old_portrayterm3'(Term, Renames, Renames, _Precedence) :-
    is_persistent_object_var(Term), !,
    '$persistent_name'(Term, Name),
    put(0' ),
    put(0'#),
    '$write_atom'(Name).
'$old_portrayterm3'(Term, Renames, Renames2, _Precedence) :-
    is_object_var(Term),
    '$object_var_prefix'(Objvar), !,
    '$write_atom'(Objvar),
    '$old_portray_var'(Term, Renames, Renames2).
'$old_portrayterm3'(Term, Renames, Renames, _Precedence) :-
    '$write_atom'(Term), !.
'$old_portrayterm3'(Term, Renames, Renames, _Precedence) :-
    '$write_integer'(Term), !.
'$old_portrayterm3'(List, Renames, Renames, _Precedence) :-
    isString(List), !,
    put(0'"),
    '$write_escaped_string'(List),
    put(0'").
'$old_portrayterm3'([H|T], Renames, Renames3, _Precedence) :-
    !,
    put(0'[),
    '$old_portrayterm2'(H, Renames, Renames2, 1000, complete),
    '$old_portray_tail'(T, Renames2, Renames3),
    put(0']).
'$old_portrayterm3'(Term, Renames, Renames4, Precedence) :-
    quantify(Term, Quant, Objvar, Body),
    !,
    current_op(QuantPred, quant, Quant),
    (QuantPred >= Precedence -> put(0'() ; true),
    '$old_portrayterm2'(Quant, Renames, Renames2, QuantPred, centre),
    put(0' ),
    '$old_portrayterm2'(Objvar, Renames2, Renames3, QuantPred, centre),
    put(0' ),
    '$old_portrayterm2'(Body, Renames3, Renames4, QuantPred, complete),
    (QuantPred >= Precedence -> put(0')) ; true).
'$old_portrayterm3'(Term, Renames, Renames3, Precedence) :-
    Term =.. [F|Args],
    (current_op(PrecedenceF, AssociativityF, F),
     '$old_portray_op_term'(AssociativityF, PrecedenceF, F, Args, Renames,
	 Renames2, Precedence) ->
	Renames3 = Renames2
    ;
	'$old_portrayterm2'(F, Renames, Renames2, Precedence, centre),
	put(0'(),
	'$old_portray_args'(Args, Renames2, Renames3),
	put(0'))
    ).


'$old_portray_op_term'(AssociativityF, PrecedenceF, F, Args, Renames, Renames2,
	OldPrecedence) :-
    (PrecedenceF >= OldPrecedence ->
	Portrays = [put(0'()|PortraysArgs],
	PortraysTail = [put(0'))]
    ;
	Portrays = PortraysArgs,
	PortraysTail = []
    ),
    name(AssociativityF, AssociativityList),
    '$args_to_old_portrays'(AssociativityList, Renames, Renames2, PrecedenceF, F,
		Args, PortraysArgs-PortraysTail),
    '$perform_writes'(Portrays).


'$args_to_old_portrays'([], Renames, Renames, _PrecedenceF, _F, [], WT-WT).
'$args_to_old_portrays'([Associativity|AssociativityList], Renames, Renames3,
	PrecedenceF, F, Args, [Portray|Portrays]-WT) :-
    '$arg_to_old_portray'(Associativity, Renames, Renames2, PrecedenceF, F, Args,
	ArgsTmp, Portray),
    '$args_to_old_portrays'(AssociativityList, Renames2, Renames3, PrecedenceF, F,
	ArgsTmp, Portrays-WT).


'$arg_to_old_portray'(0'f, Renames, Renames, PrecedenceF, F, Args, Args,
		'$old_portrayterm3'(F, Renames, Renames, PrecedenceF)).
'$arg_to_old_portray'(0'x, Renames, Renames2, PrecedenceF, F, [Arg|Args], Args,
		'$old_portrayterm2'(Arg, Renames, Renames2, PrecedenceX, complete)) :-
    PrecedenceX is PrecedenceF - 1.
'$arg_to_old_portray'(0'y, Renames, Renames2, PrecedenceF, F, [Arg|Args], Args,
		'$old_portrayterm2'(Arg, Renames, Renames2, PrecedenceF, complete)).



'$old_portray_args'([Arg], Renames, Renames2) :-
    !,
    '$old_portrayterm2'(Arg, Renames, Renames2, 999, complete).
'$old_portray_args'([Arg1|Args], Renames, Renames3) :-
    '$old_portrayterm2'(Arg1, Renames, Renames2, 999, complete),
    put(0',), put(0' ),
    '$old_portray_args'(Args, Renames2, Renames3).


'$old_portray_tail'(T, Renames, Renames2) :-
    var(T), !,
    put(0'|),
    '$old_portrayterm2'(T, Renames, Renames2, 1200, complete).
'$old_portray_tail'([], Renames, Renames) :-
    !.
'$old_portray_tail'([H|T], Renames, Renames3) :-
    !,
    put(0',), put(0' ),
    '$old_portrayterm2'(H, Renames, Renames2, 1000, complete),
    '$old_portray_tail'(T, Renames2, Renames3).
'$old_portray_tail'(T, Renames, Renames2) :-
    put(0'|),
    '$old_portrayterm2'(T, Renames, Renames2, 1200, complete).


'$old_portray_var'(Term, Renames, Renames2) :-
    '$rename_variable'(rename(Term, NewVar), Renames, Renames2),
%    write(NewVar).
    '$old_portrayterm3'(NewVar, _, _, _).

'$rename_variable'(Rename, Renames, Renames) :-
    '$member_var'(Rename, Renames), !.
'$rename_variable'(rename(Var, NewVar), Renames,
	[rename(Var, NewVar)|Renames]) :-
    '$get_next_variable'(Var, NewVar).

'$member_var'(rename(Var, NewVar), [rename(Var2, NewVar)|_Renames]) :-
    Var == Var2, !.
'$member_var'(Rename, [_Rename2|Renames]) :-
    '$member_var'(Rename, Renames).

'$get_next_variable'(Var, NewVar) :-
    is_object_var(Var), !,
    '$get_next_ov_var'(NewVar).
'$get_next_variable'(Var, NewVar) :-
    var(Var),
    '$get_next_meta_var'(NewVar).

'$get_next_meta_var'(Y) :-
    '$next_meta_variable'(Y),
    '$new_meta_var'(Y, Z),
    '$replace'('$next_meta_variable'(Y), '$next_meta_variable'(Z)).

'$get_next_ov_var'(Y) :-
    '$next_object_variable'(Ext),
    '$incr'('$next_object_variable'),
    number_chars(Ext, ExtStr),
    append("_", ExtStr, New),
    name(Y, New).

'$new_meta_var'(Y, Z) :-
    name(Y, Cs),
    '$next_meta_var_string'(Cs, Ds),
    name(Z, Ds).

/*----------------------------------------------------------------------------
'$next_meta_var_string'(Cs, Ds) :-
    Ds is the next variable name string after Cs.
 
        A       AA      AAA     AAAA etc
        ..      ..      ..
        Z       AZ      AAZ
                BA      ABA
                ..      ..
                BZ      ABZ
                ..      ..
                ZA      ZYA
                ..      ..
                ZZ      ZZZ
         
----------------------------------------------------------------------------*/
         
'$next_meta_var_string'(Cs, Ds) :-
    append(Rest, [C], Cs),
    ([C] \= "Z" ->
        D is C + 1,
        append(Rest, [D], Ds)
    ;    
        (Rest \= [] ->
	    '$next_meta_var_string'(Rest, NewRest),
	    append(NewRest, "A", Ds)
        ;
            Ds = "AA"
        )
    ).

/*----------------------------------------------------------------------------
'$initialise_for_renaming' :-
    initialize the meta-variable name to be used next in renaming, also
    initialize the extension of the object-variable for renaming
    object-variables in clauses asserted.
 
----------------------------------------------------------------------------*/
'$initialise_for_renaming' :-
    assert('$next_meta_variable'('A')),
    assert('$next_object_variable'(1)).
 
/*----------------------------------------------------------------------------
'$clean_up_after_renaming' :-
    remove meta-variable name to be used next and the extension of the
    object-variable used next.
 
----------------------------------------------------------------------------*/
'$clean_up_after_renaming' :-
    retract('$next_meta_variable'(_MetaVar)),
    retract('$next_object_variable'(_ObjectVar)).


/*----------------------------------------------------------------------------
'$replace'(A, B) :-
    True, if the clause A exists in the database.
    Replace clause A with clause B in the database.

    Fail on redo.
----------------------------------------------------------------------------*/
'$replace'(A, B) :-
    retract(A), !,
    assert(B).


/*----------------------------------------------------------------------------
'$incr'(F) :-
    Increment the counter, F.
        e.g. F = frame_number
             frame_number(3) --> frame_number(4)
    on backtrack undo the increment
             frame_number(4) --> frame_number(3)
----------------------------------------------------------------------------*/
'$incr'(F) :-
    X =.. [F, C],
    once(retract(X)),
    D is C + 1,
    Y =.. [F, D],
    assert(Y).
'$incr'(F) :-
    X =.. [F, C],
    once(retract(X)),
    D is C - 1,
    Y =.. [F, D],
    assert(Y),
    fail.
 
/*----------------------------------------------------------------------------
'$decr'(F) :-
    decrement the counter, F.
        e.g. F = frame_number
             frame_number(4) --> frame_number(3)
    on backtrack undo the decrement
             frame_number(3) --> frame_number(4)
----------------------------------------------------------------------------*/
'$decr'(F) :-
    X =.. [F, C],
    once(retract(X)),
    D is C - 1,
    Y =.. [F, D],
    assert(Y).
'$decr'(F) :-
    X =.. [F, C],
    once(retract(X)),
    D is C + 1,
    Y =.. [F, D],
    assert(Y),
    fail.

