/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

/*----------------------------------------------------------------------------
write(Term)
----------------------------------------------------------------------------*/
write(Term) :-
    '$simplify'(Term, Simplified), 
    writep(Simplified),
    fail.
write(_).

writeq(Term) :-
    '$simplify'(Term, Simplified),
    '$writeq'(Simplified, 1200),
    fail.
writeq(_).

writep(Term) :-
    '$writec'(Term, 1200, _, _, _),
    fail.
writep(_).

term_widget_write(Widget, Term) :-
    '$write_to_term_widget'(Widget),
    widget_write(Widget, Term).

term_widget_writeR(Widget, Term, VarNames) :-
    '$write_to_term_widget'(Widget),
    widget_writeR(Widget, Term, VarNames).

widget_writeR(Widget, Term, VarNames) :-
    '$write_to_text_widget'(Widget),
    writeR(Term, VarNames),
    '$close_write_to_text_widget'.

widget_write(Widget, Term) :-
    '$write_to_text_widget'(Widget),
    write(Term),
    '$close_write_to_text_widget'.

widget_writep(Widget, Term) :-
    '$write_to_text_widget'(Widget),
    writep(Term),
    '$close_write_to_text_widget'.

/****************************************************************************/

term_widget_portraycl(Widget, Clause) :-
    '$write_to_term_widget'(Widget),
    widget_portraycl(Widget, Clause).

widget_portraycl(Widget, Clause) :-
    '$write_to_text_widget'(Widget),
    portray_clause(Clause),
    '$close_write_to_text_widget'.

portray_clause(Clause) :-
    '$simplify'(Clause, Simplified),
    '$portraycl'(Simplified),
    writeln('.'),
    fail.
portray_clause(_).

term_widget_portraycl(Widget, Clause, Inlist, Outlist) :-
    '$write_to_term_widget'(Widget),
    widget_portraycl(Widget, Clause, Inlist, Outlist).

widget_portraycl(Widget, Clause, Inlist, Outlist) :-
    '$write_to_text_widget'(Widget),
    portraycl(Clause, Inlist, Outlist),
    '$close_write_to_text_widget'.

portraycl(Clause, Inlist, Outlist) :-
    '$simplify'(Clause, Simplified),
    portrayclp(Simplified, Inlist, Outlist).

portrayclp(Clause, Inlist, Outlist) :-
    '$writec'(Clause, 1200, true, Inlist, Outlist).

portraygoals(Goals) :-
    '$portraygoals'(Goals, [], []).

'$portraycl'((Head :- Body)) :-
    nonvar(Head),
    !,
    portrayclp(Head, [], Renames),
    writep(' :-'),
    put(10),		% newline
    '$rhs_list'(Body, Goals),
    '$portraygoals'(Goals, Renames, []).
'$portraycl'(Head) :-
    portrayclp(Head, [], []).

'$portraygoals'([], _, _).
'$portraygoals'([Goal], Renames, Renames2) :-
    !,
    put(0'	),	% TAB
    '$writec'(Goal, 1200, true, Renames, Renames2).
'$portraygoals'([Goal, Goal2|Goals], Renames, Renames3) :-
    '$portraygoals'([Goal], Renames, Renames2),
    put(0',),
    put(10),		% newline
    '$portraygoals'([Goal2|Goals], Renames2, Renames3).


/*----------------------------------------------------------------------------
writeR(Term, VarNames) 

    Remember names already given to variables 
    If a variable has not been given a name 
        a new name is generated for this variable

    Term     - a term to be written
    VarNames - a list of all variables written out during this write
----------------------------------------------------------------------------*/
writeR(Term, VarNames) :-
    '$simplify'(Term, Simplified), 
    '$writeRc'(Simplified, 1200, VarNames).
