/*
  title: projectors.h
  purpose: Projection routines called from within fview.  Routines are
    provided for 2 and 3 dimensional projections and sweeps (slowed
    projections).  A spectrogram projector is also provided.
  
  authors:  Gareth Lee.
  date:     16-08-94
  modified: 10-02-94

  Copyright (C) 1994 Gareth Lee.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  changes:
  10-02-94: Routines extracted and placed in separate compilation units.
*/


/* Prototypes for functions in projectors.c */

#define MAX_COLORS    (20)

#define X_MARGIN_3D   (80)
#define Y_MARGIN_3D   (20)

/* vertical skip (pixel) when writing label entries to the canvas */
#define LABEL_BOX_HEIGHT (14)

/*
  DEFAULT_ DEPTH_SCALING controls the degree of depth separation introduced
    between the two eye views when drawing in three dimensional modes.
    This value can be modified using a slider within the `3D colours window'.
    The default must be set within the range 10..70 (or within the panel
    range specified for the `ColorDepthSlider' widget.
*/
#define DEFAULT_DEPTH_SCALING 40

extern int DepthScaling3D;     
extern GC gc_3d, gc1_3d;

/* Drawing Functions */
void draw_3d_graphics(unsigned int, unsigned int, int);
void draw_3d_sweep(unsigned int, unsigned int, int label, unsigned int);
void draw_2d_graphics(unsigned int, unsigned int, int);
void draw_2d_sweep(unsigned int, unsigned int, int, unsigned int);
void draw_spectrogram(unsigned int, unsigned int, int);
