;;***************
;; REMOTE-COMMAND-PROCESSOR
;; -- input/output interface for processing simulator commands sent from
;; -- remote machine

(load "local-ipc.cl")


;; SIMULATOR AS SERVER SIDE
;; ========================

;;**********
;; MAKE-COMMAND-PROCESSOR
;; -- start the simulator as a server
;;
(defun make-command-processor ()
;; (let ((*local-host* (princ-to-string (get-host-name))))
;;    (setf *tcp-ip-stream* 
;;	  (if *unix-domain*
;;	      (ipc:open-network-stream :socket-file *local-socket-path*)
;;	      (ipc:open-network-stream :host *local-host* :port *inet-port*)))
  (setf ipc::*socket-pathname* *local-socket-path*)
  (ipc:start-lisp-listener-daemon)
  (list #'input-func #'output-func))

;;*******
;; GET-HOST-NAME (?)
;; -- gets the remote host-name
(defun get-host-name ()
  (format t "Enter remote host name: ")
  (read))

;; INPUT-FUNC
;; -- get the input from *tcp-ip-stream*
;;
(defun input-func ()
  (let ((next-line (read-line *tcp-ip-stream* nil 'done nil)))
    (cond ((null next-line)
	  (close *tcp-ip-stream*)
	  'nil)
	  (t
	   next-line))))

;; OUTPUT-FUNC
;; -- just prints out the result back to local lisp interface
;;
(defun output-func (return-list)
  (format t "return-status: ~a~%return value: ~a~%sensor-data: ~a~%"
	  (car return-list)
	  (cadr return-list)
	  (caddr return-list)))


;; PLANNER AS CLIENT SIDE
;; ======================

(defvar *tcp-ip-stream* nil)
(defvar *command-stream* nil)
(defvar *data-file-name* nil)
(defvar *local-host* "cabezon.cs.washington.edu")

;; OPEN-LOCAL-FILE
;; -- prompts user of the data file name and checks if it
;; -- is legal and open it if so
;;
(defun open-local-file ()
  (format t "Enter Data Filename to be processed : ")
  (setf *data-file-name* (read))
  (format t "We've got ~a .~%Type Y if correct, N if incorrect or quit to exit : " *data-file-name* )
  (let ((answer (read)))
    (cond  ((eq 'Y answer) 
	    (format t "PROCESSING START~%")
	    (setf *command-stream* 
		  (open (string-downcase *data-file-name*) :direction :input)))
	   ((eq 'quit answer)
	    (format t "PROCESS TERMINATES~%"))
	   (t
	    (format t "TRY AGAIN~%")
	    (open-local-file)))))

;;*****************
;; INIT-CONNECTION
;; -- initializes the connection btw planner and simulator
;; -- planner being the client and simulator being the server
;;
(defun init-connection ()
  (let ((*local-host* (princ-to-string (get-host-name))))
    (setf *tcp-ip-stream* 
	  (if *unix-domain*
	      (ipc:open-network-stream :socket-file *local-socket-path*)
	      (ipc:open-network-stream :host *local-host* :port *inet-port*)))
    (open-local-file)))

;;***********
;; SEND-COMMAND-FROM-PLANNER
;; -- send the command from the planner who has generated a list of commands
;;
(defun send-command-from-planner ()
  (let ((next-command (read *command-stream* nil)))
    (cond ((null next-command)
	   (close *command-stream*)
	   (write-line nil *tcp-ip-stream*))
	  (t 
	   (write-line (princ-to-string next-line) *tcp-ip-stream*)))))


;;(defun create-connection (host)
;; (let ((tcp-ip-stream (open-tcp-ip-stream host)))
;;	(values #'(lambda ()
;;				(read-line-from-stream tcp-ip-stream))
;;			#'(lambda (message-back)
;;				(write-line-to-stream tcp-ip-stream message-back)))));
;;






