;*************************************************************
;  HEADING-SUPPORT.LISP

;*******************************************************************
;  Compass support

(defun si.map-direction? (direction)
  (member direction '(n s w e ne nw se sw) :test #'eq))

(defun si.map-direction-opposite (direction)
  (cond ((eq direction 'e) 'w)
        ((eq direction 'ne) 'sw)
        ((eq direction 'n) 's)
        ((eq direction 'nw) 'se)
        ((eq direction 'w) 'e)
        ((eq direction 'sw) 'ne)
        ((eq direction 's) 'n)
        ((eq direction 'se) 'nw)
        (t nil)))

(defun si.map-direction-left (direction)
  (cond ((eq direction 'e) 'ne)
        ((eq direction 'ne) 'n)
        ((eq direction 'n) 'nw)
        ((eq direction 'nw) 'w)
        ((eq direction 'w) 'sw)
        ((eq direction 'sw) 's)
        ((eq direction 's) 'se)
        ((eq direction 'se) 'e)
        (t nil)))

(defun si.map-direction-right (direction)
  (cond ((eq direction 'e) 'se)
        ((eq direction 'ne) 'e)
        ((eq direction 'n) 'ne)
        ((eq direction 'nw) 'n)
        ((eq direction 'w) 'nw)
        ((eq direction 'sw) 'w)
        ((eq direction 's) 'sw)
        ((eq direction 'se) 's)
        (t nil)))

(defun si.map-direction-index (direction)
  (cond ((eq direction 'e) 0)
        ((eq direction 'ne) 1)
        ((eq direction 'n) 2)
        ((eq direction 'nw) 3)
        ((eq direction 'w) 4)
        ((eq direction 'sw) 5)
        ((eq direction 's) 6)
        ((eq direction 'se) 7)
        (t nil)))

(let ((x-direction (list (cons 'n 0.0)
                         (cons 'w -1.0)
                         (cons 's 0.0)
                         (cons 'e 1.0)
                         (cons 'nw -0.707)
                         (cons 'ne 0.707)
                         (cons 'sw -0.707)
                         (cons 'se 0.707)))
      (y-direction (list (cons 'n -1.0)
                         (cons 'w 0.0)
                         (cons 's 1.0)
                         (cons 'e 0.0)
                         (cons 'nw -0.707)
                         (cons 'ne -0.707)
                         (cons 'sw 0.707)
                         (cons 'se 0.707))))
  (defun comp.draw-line-in-dir (origin length direction)
    (let* ((tip-loc-x (truncate (* (float length)
                                  (cdr (assoc direction
                                              x-direction
                                              :test
                                              #'eq)))))
           (tip-loc-y (truncate (* (float length)
                                  (cdr (assoc direction
                                              y-direction
                                              :test
                                              #'eq)))))
           (tip (make-position (+ tip-loc-x (x-coord origin))
                               (+ tip-loc-y (y-coord origin)))))
      (disp.draw-line origin tip)
      tip)))

(defun comp.draw-arrow (origin length direction)
  (let* ((tip (comp.draw-line-in-dir origin length direction))
         (left (comp.draw-line-in-dir tip
                                      (* (float length) -0.8)
                                      (si.map-direction-left direction)))
         (right (comp.draw-line-in-dir tip
                                       (* (float length) -0.8)
                                       (si.map-direction-right direction))))
    (disp.fill-triangle tip left right)
    (comp.draw-line-in-dir origin
                           (* (float length) 0.8)
                           (si.map-direction-opposite direction))))

