(comment (herald constants (env tsys)))

(defmacro define-generically (name args)
  `(progn
	 (defgeneric ,name ,args)
	 (defmethod ,name ,args (declare (ignore ,@args)) nil)))

;*********************************************************************
;  Internal calls

(define-generically display-window (self))
(define-generically set-truck (self truck))
(define-generically erase (self))
(define-generically next-empty-space (self bay))

(defgeneric disp-in-small-icon (thing position))
  ;  the code for this is in displayer/icon.lisp,
  ;  but any object should be able to display itself
  ;  idiosyncratically

;**********************************************************************




;  External calls     

(define-generically dm-add (self bay obj))
(define-generically dm-del (self bay obj))
(define-generically dm-empty (self bay))
(define-generically dm-set (self obj val))
(define-generically dm-set (self obj val))
(define-generically dm-move (self arm loc))
(define-generically dm-close (self))
(define-generically dm-locate-obj (bay obj))
(define-generically dm-mnes (self arm loc))
(define-generically dm-speak (self x))
(define-generically dm-redraw (self appendage obj))
(define-generically dm-highlight (self))      
(define-generically dm-unhighlight (self))      
