;;; Note that when the documentation refers to operations,
;;; everything is now implemented in CLOS classes, instances
;;; and generic functions

;;; Everything that was a PACKAGE is now a PARCEL because of 
;;; conflicts in common lisp

;;; check printing etc

; --------------------------------------------------------------------
; ** Simulator support for  CONTAINERS 
; ----------------------------------------------------------
;
; Things defined in this file:
;
; Functions:
;
; Object builders:
;  (SI:MAKE-CONTAINER-GENERIC id kind size bigness tool-needs visibles)
;
; This file makes reference to things in OPERATIONS
;                                        LOWLEVEL
;                                        
; --------------------------------------------------------------------
; ** Simulator support for THINGOID CONTAINERS
; --------------------------------------------
; THINGOIDS can be put in CONTAINERS.  A CONTAINER is a thingoid that
;  can hold other thingoids and a generic container is a thingoid 
;  itself.  When a thingoid is inside a container it is invisible to
;  all other objects in the simulation unless it is of a class for
;  which the container is invisible.  Examples of such classes are
;  paper containers and radioactive thingoids.
; CONTAINERS can be placed inside other containers but not VESSELS.
; Both CONTAINERS and VESSELS are parcelS
; --------------------------------------------------------------------
; * Generic CONTAINER constructor
; -------------------------------
; This function creates a single object of type CONTAINER.  The object
;  created is also of type THINGOID, parcel and ENVIRONMENT (see the
;  file "OPERATIONS.T").  The properties of this object for the
;  simulation are given by the arguments.  Note that TRUCK cargo bays,
;  tire bays and weapons bays are generic containers.
;
; (SI:MAKE-CONTAINER-GENERIC id kind capacity bigness tool-needs visibles)
;  -    id: A globally unique symbol to differentiate this object from
;            all others.
;  -  kind: A symbol or list of symbols giving additional classes that
;            this object will belong to.
;  -  capacity: An integer giving the maximum sum of bignesses that this
;            object can hold.  Ie. gives a limit on the number of
;            other objects this object can contain.
;  - bigness: An integer giving the pseudo-size of this object
;            when empty.
;  - tool-needs: A list of object classes that a robot arm must already
;            hold before this object can be picked up.
;  - visibles: A list of object classes that this object is
;            transparent to.


(defun si.make-container-generic (id kind capacity bigness tool-needs visibles)
  (let ((new-thing (make-instance 'container
                                  :id id
                                  :kind kind
                                  :capacity capacity
                                  :bigness bigness
                                  :tool-needs tool-needs
                                  :visibles visibles)))
    (setf (space-empty new-thing) capacity)
    (if (symbolp kind)
      (setf (kind new-thing) (list kind)))
    (setf (id-key new-thing) (if (null id) (make-unique-id 'container) '()))
    new-thing))

