(comment (herald worlds))

; --------------------------------------------------------------------
; * Operations on objects of type world *
; ---------------------------------------

(defgeneric move-world-ahead (self delta-time))

(defclass world (environment)
  ((environment :type environment :initform *undefined-object*)
   (world-map :initform nil :accessor world-map :initarg :map)
   (num-sectors :accessor num-sectors :initarg :num-sectors)
   (start-time :accessor start-time :initarg :start-time :initform (number->time 0))
   (history-list :accessor history-list :initarg :history-list)
   (my-time :accessor my-time :initform 0)
   (update-num :accessor update-num :initform 1)))

;;; ** Operations handled by all objects
; ** Special WORLD type operations

;         ((WEATHER self sector) (svref weather-list sector))
;         ((ENEMY-ACTIVITY self sector) (svref enemy-list sector))
;         ((DAY-TIME self) day-time-now)

(defmethod actual-time ((self world)) 
  (my-time self))

;;; ** Functions to update the world as time passes

(defmethod move-world-ahead ((self world) delta-time)
  (cond ((> delta-time 0)
         (setf (my-time self)
              (+ delta-time (my-time self)))
         (process-history-list (my-time self))))
  (setf (update-num self) (+ 1 (update-num self)))
  (update-num self))

;;; ** Functions required for debugging
;;  Changed this to a defun.... it's absurd to think that 
;   anybody else would want to do a world-reset!!!!

(defun world-reset (self)
  (setf (my-time self) 0)
  (set-new-history (num-sectors self) (history-list self))
  (move-world-ahead self
                    (time->number (start-time self))))

;;; ** Functions required for neatness

(defmethod show ((self world))
  (format t "World state: ~a~&"
          (number->time (my-time self)))
  (do ((index 1 (+ 1 index)))
      ((> index (num-sectors self)) t)
    (format t
            " Sector: ~d   Day-time: ~a, Weather: ~a, Enemy Activity: ~a~&"
            index
            (current-global-value 'day-time index)
            (current-global-value 'weather index)
            (current-global-value 'enemy-activity index)))
  t)

