(define (numerator quad)
  (if (number? quad)
      quad
      (cadr quad)))
(define (denominator quad)
  (if (number? quad)
      1
      (caddr quad)))
(define (int-part quad)
  (let ((n (numerator quad)))
    (if (number? n)
	n
	(cadr n))))
(define (surd-part quad)
  (let ((n (numerator quad)))
    (if (number? n)
	0
	(car (cdaddr n)))))
(define (surd quad)
  (let ((n (numerator quad)))
    (if (number? n)
	0
	(cadadr (cdaddr n)))))
(define (make-frac num denom)
  (let ((g (gcd num denom)))
    (if (member (/ denom g) '(-1 1))
	(/ num denom)
	`(/ ,(/ num g) ,(/ denom g)))))
(define (make-quad int-part surd-part surd denom)
  (if (eq? surd-part 0)
      (make-frac int-part denom)
      (let ((g (gcd int-part surd-part denom)))
	`(/ (+ ,(/ int-part g) (* ,(/ surd-part g) (sqrt ,surd)))
	    ,(/ denom g)))))
(define (frac+ f g)
  (make-frac (+ (* (denominator f) (numerator g))
		(* (numerator g) (denominator f)))
	     (* (denominator f) (denominator g))))
(define (frac- f . g)
  (if (null? g)
      (make-frac (- (numerator f)) (denomintaor f))
      (frac+ f (frac- (car g)))))
(define (frac* f g)
  (make-frac (* (numerator f) (numerator g))
	     (* (denominator f) (denominator g))))
(define (frac/ f g)
  (make-frac (* (numerator f) (denominator g))
	     (* (denominator f) (* numerator g))))

(define (conjugate f)
  (make-quad (int-part f) (- (surd-part f)) (surd f) (denominator f)))
(define (norm f)
  (quad* f (conjugate f)))
(define (quad+ f g)
  (let ((c (denominator f))
	(d (denominator g)))
    (make-quad (+ (* (int-part f) d) (* c (int-part g)))
	       (+ (* (surd-part f) d) (* c (surd-part g)))
	       (surd f)
	       (* c d))))
(define (quad- f . g)
  (if (null? g)
      (make-quad (- (int-part f)) (- (surd-part f)) (surd f) (denominator f))
      (quad+ f (quad- g))))
(define (quad* f g)
  (make-quad (+ (* (int-part f) (int-part g))
		(* (surd-part f) (surd-part g) (surd f)))
	     (+ (* (int-part f) (surd-part g))
		(* (surd-part f) (int-part g)))
	     (surd f)
	     (* (denominator f) (denominator g))))
(define (quad/ f g)
  (let ((q (quad* f (conjugate g)))
	(n (norm g)))
    (make-quad (* (int-part q) (denominator n))
	       (* (surd-part q) (denominator n))
	       (surd q)
	       (* (denominator q) (numerator n)))))

(define (frac->quadratic frac)
  (if (null? (cdr frac))
      (car frac)
      (if (list? (car frac))
	  1
	  (quad+ (car frac) (quad/ 1 (frac->quadratic (cdr frac)))))))

(define (frac->number frac)
  (if (null? (cdr frac))
      (car frac)
      (if (list? (car frac))				; a period
	  (eval (frac->quadratic frac))
	  (+ (car frac)
	     (/ 1. (frac->number (cdr frac)))))))

