/* PD624 Code for the answer to exercise 3.9 */

/* Patient frames are the same as in ans3-7.pl.  They are repeated here
so that the system can run as a whole.  Rules are at the end of this file */

patient subclass_of person with
  coughing:
    [value: unknown,
     type: [persistent,intermittent,dry,non_dry],  /* legal fillers */
     cardinality: any],                            /* any number allowed */
  nose:
    [value: unknown,
     type: [runny,blocked,bleeding,broken,lacerated],
     cardinality: any],
  sneezing:
    [value: unknown,                 /* default case is unknown */
     type: [yes,no],                 /* simple 'yes' or 'no' expected */
     cardinality : 1],               /* naturally, only 1 is allowed */
  throat:
    [value: unknown,
     type: [dry,sore],
     cardinality: 1],
  hoarse_voice:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  laryngeal_discomfort:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  fever:
    [value: unknown,
     type: [yes,no,slight,intermittent],
     cardinality : 1],
  shivering:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  muzzy_feeling_head:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  eyes:          /* could have used 'red_itchy_watery_eyes: yes' instead */
    [value: unknown,
     type: [red, itchy, watery],
     cardinality: any],
  malaise:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  headache :
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  aches_and_pains:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  back:                    /* an extra slot, not actually relevant, but... */
    [value: unknown,       /* used to cater for patient alice below */
     type: [sore, stiff],
     cardinality: any].



/*  ============ specific patients ================================ */

alice instance_of patient with
  nose: [runny, blocked],
  sneezing: yes,
  eyes: [red, itchy, watery],
/* alice may also report other features e.g. a sore back which may or not
   be relevant */
  back: sore.

bob instance_of patient with
  nose: blocked,
  coughing: [persistent,dry],
/* maybe the coughing also gave him a headache */
  headache: yes,
  hoarse_voice: yes,
  laryngeal_discomfort: yes,
  fever: yes,
  malaise: yes.

christine instance_of patient with
  nose: runny,
  sneezing: yes,
  throat: dry,
  fever: [slight, intermittent],
  muzzy_feeling_head: yes.

david instance_of patient with
  coughing: [persistent,dry],
  throat: sore,
  fever: yes,
  shivering: yes,
  malaise: yes,
  headache: yes,
  aches_and_pains: yes.




/* ------------------- diagnosis rules ------------------------------- */

rule start forward
  if
    start
  then
    add diagnosing &
    remove start.

rule hay_fever forward
  if
     diagnosing &
     X instance_of patient &
     the nose of X is runny &
     the nose of X is blocked &
     the sneezing of X is yes &
     the eyes of X is red &
     the eyes of X is watery &
     the eyes of X is itchy
  then
     add [X, has, hay_fever] &
     announce [nl,X,' has got hay fever',nl].

rule laryngitis forward
  if
     diagnosing &
     X instance_of patient &
     the coughing of X is persistent &
     the coughing of X is dry &
     the hoarse_voice of X is yes &
     the laryngeal_discomfort of X is yes &
     the fever of X is yes &
     the malaise of X is yes
  then
     add [X, has, laryngitis] &
     announce [nl,X,' has got laryngitis',nl].

rule common_cold_with_fever forward
  if
     diagnosing &
     X instance_of patient &
     the nose of X is runny &
     the sneezing of X is yes &
     the throat of X is dry &
     the fever of X is yes &
     the muzzy_feeling_head of X is yes
  then
     add [X, has, common_cold_with_fever] &
     announce [nl,X,' has a common cold with fever',nl].

rule common_cold_without_fever forward
  if
     diagnosing &
     X instance_of patient &
     the nose of X is runny &
     the sneezing of X is yes &
     the throat of X is dry &
     the muzzy_feeling_head of X is yes
  then
     add [X, has, common_cold_without_fever] &
     announce [nl,X,' has a common cold without fever',nl].

rule influenza forward
  if
     diagnosing &
     X instance_of patient &
     the coughing of X is persistent &
     the coughing of X is dry &
     the throat of X is sore &
     the fever of X is yes &
     the shivering of X is yes &
     the malaise of X is yes &
     the headache of X is yes &
     the aches_and_pains of X is yes
  then
     add [X, has, influenza] &
     announce [nl,X,' has got influenza',nl].

rule halt forward
  if
     diagnosing    /* specificity ensures that this is chosen last of all */
  then
     remove diagnosing &
     announce [nl,'Diagnosis session finished --- no more conclusions',nl,
               'Bye.',nl] &
     halt.

