/* PD624 Code for answer to exercise 5-1
Rule-based medical diagnosis system from
Section 5.1 of PD624 'Knowledge Engineering'
*/
/* ================ I M P O R T A N T   M E S S A G E ================== */
/* The way the database is set up at the moment, only one person
   (namely 'baker') has a diagnosable disease!!!  It is your responsibility
   to augment both the frames and the rules if you wish them to 'mesh'
   on more cases (as in course exercise 5.1) . */

patient subclass_of person with
  symptoms: [].   /* deliberately empty as 'reminder' about this slot */

abel instance_of patient with
  symptoms: [cough, sneezing, fever, hoarse_voice].

baker instance_of patient with         /* baker has hay_fever_2 */
  symptoms: [sneezing, runny_nose, red_itchy_watery_eyes].

charlie instance_of patient with
  symptoms: [cough, sneezing, fever, dry_throat].

david instance_of patient with
  symptoms: [cough, sneezing, fever, shivering].


/*
Notice how rules init1, init2, and init3 below are structured.
In particular, init1 displays an opening screen using 'announce',
then uses 'single_choice_menu' to display a pop-up menu of choices,
of which only one may be selected (using the arrow keys on the
keypad, then the 'ENTER' key, or mouse left-button).
Rule init2 uses 'query' to display a dialogue box into which a name
can be typed, and 'multiple_choice_menu' to display a pop-up menu of
choices, of which several may be selected (using the arrow keys on
the keypad, then the 'ENTER' key (or mouse left-button) to 'toggle'
the 'tick-mark' on the far right 'on' or 'off', then the 'ESC' key
(or mouse right-button) to indicate that the selection is complete.

The format for these menu primitives is as follows:

   single_choice_menu(MessageList, ChoiceList, SingleResult).
   multiple_choice_menu(MessageList, ChoiceList, AllResults).

In both cases, MessageList is a list of elements just like those used
by announce (except you want to make sure that it fits on one line),
to appear at the top of the pop-up menu.  ChoiceList is the list of
items which the user will be asked to select from.  SingleResult should
be a variable of your own choosing (e.g. Ans) which will take as its
value the single menu choice ultimately made by the user at run-time.
AllResults, analogously, will take as its value a *LIST* of all choices
made by the user at run-time.  The rules init1 and init2 indicate
typical ways in which you might want to use the result of the user choices,
namely noting the information directly into frame memory.  Alternatively,
you might want to use 'add' to place the information into working memory,
e.g.    add [current_patient, is_called, Name]
*/

rule init1 forward
  if
    start
  then
    announce
     [        '         R E S P I R A T O R Y ',  nl,
              '             D I S E A S E' ,      nl,
              '          D I A G N O S T I C',    nl,
              '              S Y S T E M ',       nl,
              '         { V E R S I O N - 1 }',   nl,
              '                         ',     nl,
              'For illustrative purposes only, namely',  nl,
              'teaching  about  Knowledge Engineering,',   nl,
              '*NOT*  medical  diagnosis!   No  other',      nl,
              'purpose  intended  or  implied.'
     ] &
    single_choice_menu(
          ['What is the patient''s name?'],
          [abel, baker, charlie, david, 'other...'],
          Name) &
    note the name of patient is Name.

rule init2 forward
  if
    start &
    the name of patient is 'other...'
  then
    query [' Please enter the name below: '] receives_answer X &
    note the name of patient is X &  /* replaces 'other...' with X */
    multiple_choice_menu(
          [' Select main symptom(s): '],
          [fever, dry_throat, shivering, runny_nose, sneezing,
           cough, hoarse_voice, red_itchy_watery_eyes],
          S) &   /* S will have as its value the list of all user-choices! */
    note (X instance_of patient with symptoms: S) & /* stores all symptoms */
    remove start &
    add goal(hypothesize).

rule init3 forward  /* this rule only selected if name is NOT 'other...' */
  if
    start &
    the name of patient is X
  then
    remove start &
    add goal(hypothesize).

/* strategy-switching rules only get selected when there's nothing better! */
rule switch_strategies_1 forward
  if
    goal(hypothesize)
  then
    remove goal(hypothesize) &
    add goal(discriminate).

rule switch_strategies_2 forward
  if
    goal(discriminate)
  then
    remove goal(discriminate) &
    add goal(choose_winner).

rule switch_strategies_3 forward
  if
    goal(choose_winner)
  then
    remove goal(choose_winner) &
    halt.                 /* This is where the whole thing ends  */

rule hypothesize_laryngitis forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is fever &
    the symptoms of N is dry_cough &
    the symptoms of N is malaise
  then
    add possible(laryngitis).  /* place it in working memory */

rule hypothesize_influenza forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is fever &
    the symptoms of N is dry_cough &
    the symptoms of N is malaise
  then
    add possible(influenza).  /* place it in working memory */

rule hypothesize_cold forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is sneezing &
    the symptoms of N is runny_nose&
    the symptoms of N is fever
  then
    add possible(common_cold).  /* place it in working memory */

rule hypothesize_hay_fever_1 forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is sneezing &
    the symptoms of N is blocked_nose
  then
    add possible(hay_fever_1).  /* place it in working memory */

rule hypothesize_hay_fever_2 forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is sneezing &
    the symptoms of N is runny_nose
  then
    add possible(hay_fever_2).  /* place it in working memory */

rule eliminate forward
  if
    goal(discriminate) &
    possible(X) &
    deduce passes_discriminating_test(X)
  then
    add likely(X).

rule simple_selection forward
  if
    goal(choose_winner) &
    likely(X)
  then
    announce ['A likely diagnosis is that the patient has ', X].

rule prove_laryngitis backward
  if
    query 'does the patient show signs of inflamed larynx'
        receives_answer yes
  then
    passes_discriminating_test(laryngitis).

rule prove_hay_fever_1 backward
  if
    query 'does the patient show positive reaction to allergens'
        receives_answer yes
  then
    passes_discriminating_test(hay_fever_1).

rule prove_hay_fever_2 backward
  if
    query 'does the patient show positive reaction to allergens'
        receives_answer yes
  then
    passes_discriminating_test(hay_fever_2).

rule prove_cold backward
  if
    query 'does the patient show positive reaction to allergens'
        receives_answer no
  then
    passes_discriminating_test(common_cold).

rule prove_influenza backward
  if
    query 'does the patient show signs of shivering or aches'
         receives_answer yes
  then
    passes_discriminating_test(influenza).

