/* PD624 code file: CH7-5-1
   Very rudimentary flush toilet simulation, to accompany section 7.5.1.
   More sophisticated simulations are found in ANS7-3.PL and ANS7-4.PL
*/
rule init forward
  if
    start   /* special symbol which is always in WM at start */
  then
    remove start &
    strategy [refractoriness] &  /* SPECIFITY IS TABOO HERE */
              /* RECENCY IS TABOO AS WELL IN THIS CONTEXT -- so this differs
                 slightly from what is presented in the text . */
    note the level of tank1 is 0 &
    add tank_filling.  /* begin with empty tank, but fill it up first */

rule stop_it forward
  if
     tank_filling &
     the level of tank1 > 10   /* will eventually reach this */
  then
     announce ['Tank is full',nl] &
     strategy [refractoriness, recency, specificity] & /* restore defaults */
     halt .

rule filling forward
  if
     tank_filling &
     the level of tank1 is L &
     the flow_rate of pipe1 is R
  then
     prolog(NewLevel is L + R) &  /* must call prolog to do sums */
     note the level of tank1 is NewLevel. /* tracing option 5 shows this */

/* alternatively, include the next line in the 'then' part of the above
rule:
     announce ['The level of tank1 is ',NewLevel,nl]
*/


 /* the 'note' above OVERWRITES former level of tank1 !!!!! */


tank1 instance_of tank with
  height: 5,  /* all these slots are dummies at the moment */
  width: 4,
  depth: 3,
  regulator: float1.

float1 instance_of float with
  arm_length: 4,
  regulated_inlet: pipe1.

pipe1 instance_of pipe with
  thickness: 5,
  comes_from: mains_supply,
  goes_to: tank1,
  flow_rate: 5.  /* starting flow_rate is 5, gets changed later */


/* the next line ensures that updates to working memory or frame changes
are displayed on the screen at run-time.  The equivalent way to do this
yourself would be to select option 5 from the menu which appears after
you type in
   ?- tracing.
*/
?- reverse_option('show new working memory elements or frame changes',enable).
?- write('[Tracing option 5 (show new working memory elements or').
?- nl, write(' frame changes) has been enabled in file CH7-5-1.PL]').
