/* PD624 Code file for section 7.6
       Simulation of Gas Exchange and Respiratory Control */

/* A version of the qualitative gas exchange model WITHOUT the feedback
   influence of lung contraction on CO2 level */

/* See the text of chapter 7, last exercise for a description of the frames
   and the propagating rule */

/* The whole thing is started by the set_going rule which makes the level of
   body_activity high */

/* Pure Prolog predicates defined: value_change/3
                                   direction_of_change/3
(but text illustrates how to define these in MIKE itself)
*/


parameters subclass_of classes with
    old_level: [value: normal,
                type: [low,normal,high]],
    level: [value: normal,
            type: [low,normal,high]],

    effect: [value:unknown, type:influences],
    already_changed: [value: no,
                      type: [yes,no]].
    /* The last slot is a way to stop the propagate_parameters rule from
       firing again on the same influenced parameter as soon as its value
       is changed. In such an instance the line
                 the level of Aff_param is Aff_old &
       could cause a further firing if we don't check that the parameter
       is already changed. */

influences subclass_of classes with
    responsible_parameter: [value: unknown,
                            type: parameters],
    affected_parameter: [value: unknown,
                         type: parameters],
    direction_of_effect: [value: unknown,
                          type: [same,opposite]].

heart_strength instance_of parameters with
    effect: heart_strength_blood_flow.

blood_flow instance_of parameters with
    effect: blood_flow_o2_supply.

o2_percent instance_of parameters with
    effect: o2_percent_o2_supply.

o2_supply instance_of parameters with
    effect: unknown.

body_activity instance_of parameters with
    effect: body_activity_co2_level.

co2_level instance_of parameters with
    effect: co2_co2_receptors.

co2_receptor_activity instance_of parameters with
    effect: [co2_receptors_accelerator_activity,
                 co2_receptors_chest_muscles].

accelerator_activity instance_of parameters with
    effect: accelerator_activity_heart_strength.

chest_muscle_contraction instance_of parameters with
    effect: chest_muscles_lung_contraction.

lung_contraction instance_of parameters with
    effect: lung_contraction_o2_percent.

body_activity_co2_level instance_of influences with
    responsible_parameter: body_activity,
    affected_parameter: co2_level,
    direction_of_effect: same.

co2_co2_receptors instance_of influences with
    responsible_parameter: co2_level,
    affected_parameter:co2_receptor_activity,
    direction_of_effect: same.

co2_receptors_accelerator_activity instance_of influences with
    responsible_parameter: co2_receptor_activity,
    affected_parameter: accelerator_activity,
    direction_of_effect: same.

co2_receptors_chest_muscles instance_of influences with
    responsible_parameter: co2_receptor_activity,
    affected_parameter: chest_muscle_contraction,
    direction_of_effect: same.

chest_muscles_lung_contraction instance_of influences with
    responsible_parameter: chest_muscle_contraction,
    affected_parameter: lung_contraction,
    direction_of_effect: same.

lung_contraction_co2 instance_of influences with
    responsible_parameter: lung_contraction,
    affected_parameter: co2_level,
    direction_of_effect: opposite.

lung_contraction_o2_percent instance_of influences with
    responsible_parameter: lung_contraction,
    affected_parameter: o2_percent,
    direction_of_effect: same.

o2_percent_o2_supply instance_of influences with
    responsible_parameter: o2_percent,
    affected_parameter: o2_supply,
    direction_of_effect: same.

accelerator_activity_heart_strength instance_of influences with
    responsible_parameter: accelerator_activity,
    affected_parameter: heart_strength,
    direction_of_effect: same.

heart_strength_blood_flow instance_of influences with
    responsible_parameter: heart_strength,
    affected_parameter: blood_flow,
    direction_of_effect: same.

blood_flow_o2_supply instance_of influences with
    responsible_parameter: blood_flow,
    affected_parameter: o2_supply,
    direction_of_effect: same.


/* ========================= R U L E S ============================= */

rule set_going forward
    if
      start
    then
      remove start &
      announce [nl, 'Body activity increasing above normal.',nl] &
      note the level of body_activity is high.

rule propagate_parameters forward
   if
      Param instance_of parameters &
      the level of Param is New &
      the old_level of Param is Old &
      prolog(value_change(Change,Old,New)) &
          /* Change gets instantiated to either `increase' or `decrease' */
      the effect of Param is Influence &
      the affected_parameter of Influence is Aff_param &
      the already_changed of Aff_param is no &
      the level of Aff_param is Aff_old &
      the direction_of_effect of Influence is Direction &
          /* Direction is either `same' or `opposite' */
      prolog((direction_of_change(Direction,Change,Resulting_change),
              value_change(Resulting_change,Aff_old,Aff_new)))
 /* Resulting_change gets instantiated to either'increase' or `decrease' */
 /* Aff_new gets instantiated to the new value for the affected parameter */
   then
      note the old_level of Aff_param is Aff_old &
      note the level of Aff_param is Aff_new &
      note the already_changed of Aff_param is yes &
      announce [Param, ' influences ', Aff_param, ' in ',
                Direction, ' direction:', nl,
                '     New ', Aff_param, ' is ', Aff_new, nl].



/* Pure Prolog definitions follow (but see text for how to use MIKE frames
to achieve the same effect */

/* value_change/3 relates the direction of change (increase or decrease)
   to the old and new values for a particular parameter. */

value_change(increase,low,normal).
value_change(increase,normal,high).
value_change(increase,high,high).
value_change(decrease,normal,low).
value_change(decrease,high,normal).
value_change(decrease,low,low).

/* direction_of_change/3 relates the direction of influence (same or
   opposite) with the direction of change in the influencing parameter
   (increase or decrease) and the direction of change in the influenced
    parameter */

direction_of_change(same,increase,increase).
direction_of_change(same,decrease,decrease).
direction_of_change(opposite,increase,decrease).
direction_of_change(opposite,decrease,increase).




