/* PD624 Unit2 Code : code for exercise 2.3 */

/* numbers are added for convenience and to correspond to the text */
/* The tracing capabilities are switched on for you automatically when
   you reconsult this file (the code to do this is at the end of the
   file).  To see the 'history chart' when you are done, type in
       ?- show history.
   and you will get a chart showing the history of rule execution.
   Very fine-grained tracing information is available if you select
   tracing option number 9.  To do this, type
       ?- tracing.
   and then type in '9.' when you get the '==>' prompt, as follows:
       ==> 9.
   Any time you see Prolog's '?-' prompt, you can type in
       ?- show symbols.
   For a reminder of what the fine-grained (single-step) symbols mean.
   As you will no doubt realise, you can switch OFF all of the tracing
   options EXCEPT for number 10, and thereby just use ?- show history
   as an instant solution to this exercise.  We recommend that you
   work through the detailed trace first, however.
*/

/* BEWARE: the tracing will generate a lot of information which you will
   need in order to solve the exercise.  Be prepared to use the scroll/
   noscroll option on your machine so you can follow the trace info.
*/

/* 1 */
rule initialisation_rule forward
 if
  start
 then
  add 'kettle is empty' &
  add 'kettle is plugged in' &
  add 'sugar required' &
  add 'milk required' &
  add 'teacup is empty' &
  add 'kettle is switched off'.

/* 2 */
rule boilingWater_UnplugKettle forward
 if
  'kettle is empty' &
  'kettle is plugged in'
 then
   remove 'kettle is plugged in' &
   add 'kettle is not plugged in'.

/* 3 */
rule boilingWater_FillKettle forward
 if
  'kettle is empty' &
  'kettle is not plugged in'
 then
   remove 'kettle is empty' &
   add 'kettle is full'.

/* 4 */
rule boilingWater_PlugInKettle forward
 if
   'kettle is full' &
   'kettle is not plugged in'
then
   remove 'kettle is not plugged in' &
   add 'kettle is plugged in'.

/* 5 */
rule boilingWater_SwitchOn forward
 if
   'kettle is full' &
   'kettle is plugged in'
 then
    remove 'kettle is switched off' &
    add 'kettle is switched on'.

/* 6 */
rule boilingWater_WaterBoiled forward
 if
   'kettle is full' &
   'kettle is plugged in' &
   'kettle is switched on'
 then
    add 'water is boiled'.

/* 7 */
rule makingTea_AddTeabag forward
 if
   'teacup is empty'
 then
   add 'teabag in cup'.

/* 8 */
rule makingTea_AddBoilingWater forward
 if
   'teabag in cup' &
   'water is boiled'
 then
    add 'boiling water in cup'.

/* 9 */
rule makingTea_BrewingTea forward
 if
   'teabag in cup' &
   'boiling water in cup'
 then
    add 'tea has brewed'.

/* 10 */
rule makingTea_RemoveTeaBag forward
 if
   'teabag in cup' &
   'tea has brewed'
 then
    remove 'teabag in cup' &
    add 'teabag removed'.

/* 11 */
rule makingTea_MilkAndSugar forward
 if
   'teabag removed' &
   'milk required' &
   'sugar required'
 then
    add 'milk requirement satisfied' &
    add 'sugar requirement satisfied'.

/* 12 */
rule makingTea_MilkRequired forward
 if
   'teabag removed' &
   'milk required'
 then
    add 'milk requirement satisfied'.

/* 13 */
rule makingTea_SugarRequired forward
 if
   'teabag removed' &
   'sugar required'
 then
    add 'sugar requirement satisfied'.

/* 14 */
rule makingTea_StirringMilkAndSugar forward
 if
   'milk requirement satisfied' &
   'sugar requirement satisfied'
 then
    add 'tea has been stirred'.

/* 15 (disjunctive version, as used in exercise 2.3) */
rule makingTea_StirringMilkOrSugar forward
 if
   'milk requirement satisfied' or
   'sugar requirement satisfied'
 then
   add 'tea has been stirred'.

/* 15 (original version, commented out for exercise 2.3) */
/*
rule makingTea_StirringMilk forward
 if
   'milk requirement satisfied'
 then
    add 'tea has been stirred'.
*/

/* 16 (original version, commented out for exercise 2.3) */
/*
rule makingTea_StirringSugar forward
 if
    'sugar requirement satisfied'
 then
     add 'tea has been stirred'.
*/

/* 16 (with revised numbering in effect; see above) */
rule makingTea_StirringTea forward
 if
    'teabag removed'
 then
     add 'tea has been stirred'.

/* 17 (with revised numbering in effect: see above) */
rule makingTea_TeaIsMade forward
 if
    'tea has been stirred'
 then
     add 'tea is ready' &
     announce [nl, 'The tea is now ready!',nl] &
     halt.

/* this is a bit of MIKE internals that show the rule and the
   working memory elements */
?- reverse_option('show new working memory elements or frame changes',enable).
?- reverse_option('show chosen rule',enable).
?- reverse_option('show conflict set',enable).
?- reverse_option('show history on request',enable).
?- write('[Tracing option 5 (show new working memory elements or').
?- nl, write(' frame changes) has been enabled in file EX2-3.PL]').
?- nl.
?- write(' So have options 1 (show chosen rule) and 6 (show conflict set).').