/*--------------------------------------------------------------------------
 *  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any non-commercial purpose without fee is hereby granted,
 *  provided that the above copyright notice appears in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation.
 *
 *  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 *  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 *  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 *  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 *  SOFTWARE.
 *---------------------------------------------------------------------------
 *  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE                         
 *--------------------------------------------------------------------------
 */




#include<math.h>
#include"cmex.h"

#define IN1 prhs[0] /* IN1 ist nin */
#define IN2 prhs[1] /* IN2 ist nout*/
#define IN3 prhs[2] /* IN3 ist die matrix extsetdesc*/
#define IN4 prhs[3] /* mewert-matrix, gleiche reihenfolge wie setdesc*/
#define IN5 prhs[4] /* max_sections in extsetdesc */

#define OUT plhs[0]  /* analys-matrix */

user_fcn(nlhs, plhs, nrhs, prhs)
  int nlhs, nrhs;
  Matrix *plhs[], *prhs[];

{
float fr,fl;
float fi,fj;
float N,M,alpha,beta;
float mu[9];
float Ls,Rs,w,L,R;
float spalte,floc;

int loc,nin,nout,treffer,sections,max_sections;
int pos[9];
int i,j,k;


nin=(IN1->pr)[0]; nout=(IN2->pr)[0]; max_sections=(IN5->pr)[0];

OUT=create_matrix(nin,max_sections,REAL);
for(i=0;i<nin*max_sections;i++)
      (OUT->pr)[i]=0.0;

for(i=0;i<9;i++) mu[i]=0.0;
for(i=0;i<9;i++) pos[i]=0;


for(j=1;j<=nin;j++)
  {
/*
  vorsicht: indices i,j mssen auf eine zahl umgerechnet werden
  ist z die zeile und s die spalte (z,s), ergibt sich der index zu
  (s-1)*zmax+z-1; dabei ist zmax die anzahl der zeilen
*/


/*  zeilenzahl sd und die der mematrix ist gleich */


  w=(IN4->pr)[j-1];
  fl=w*(IN4->pr)[nin+j-1];
  fr=w*(IN4->pr)[2*nin+j-1];
  Ls=w-fl;
  Rs=w+fr;

  treffer=0;
			    
  /* test auf treffer im gesamten intervall */      

  sections=(IN3->pr)[j-1];
  for(fi=1.;fi<=sections;fi+=1.)
	{
	fj=(float) j;

	floc=(nin+nout)*(fi*4.-3.)+fj-1.;
	loc=(int) floc;
	N=(IN3->pr)[loc];

	floc=(nin+nout)*(fi*4.-2.)+fj-1.;
	loc=(int) floc;
	M=(IN3->pr)[loc];

	floc=(nin+nout)*(fi*4.-1.)+fj-1.;
	loc=(int) floc;
	alpha=(IN3->pr)[loc];

	floc=(nin+nout)*(fi*4.)+fj-1.;
	loc=(int) floc;
	beta=(IN3->pr)[loc];		  

	if( (Ls<(M+beta)) && (Rs>(N-alpha)) )
	  {
	  treffer++;
	  pos[treffer]=(int) fi;
	  if(w>M)
	      { mu[treffer]=(M-w)/(beta+fl)+1.;
		goto Aus; }
	  if(w<N)
	       mu[treffer]=(w-N)/(fr+alpha)+1.;
	  else
	       mu[treffer]=1.0; 
	  }
	Aus:
	;
	}
	

	for(k=1;k<=treffer;k++)
	   {
	   (OUT->pr)[(pos[k]-1)*nin+j-1]=mu[k];
	   }   

  } /* ende j*/

return 0;
} /* hier endet user-fcn */
