function [reg]=makerule2(set,setdesc,nr)

%MAKERULE2 is called by makerule or editrule

% Stephan Molt 01-09-93

hold off;

n_in=abs(set(1,1));
n_out=abs(set(1,21));


axis('off');

% matrix der regel bereitstellen (-> geht dann schneller)
rule=init2(n_in,n_out);

axis([0 1 0 1]);
txt=['Nr of Rule',num2str(nr)];
text(0.,1.0,txt)
text(0,0.95,'INPUT-VARIABLES');
i=1;
string=[];


% schleife durch alle eingangsgroessen: kontroll-objekte wie buttons und
% text definieren und darstellen; die handles werden benoetigt, damit man
% sie spaeter loeschen kann
for t=1:n_in
  setstr(string);
  string=['ruledef(',num2str(i),')'];
  txt=set(t+1,1:24);
  text(0 ,0.93-0.06*t,txt);
  h(t)=text(0.3,0.93-0.06*t,'ANY');
  handle(i)=uicontrol('style','pushbutton','string','+',...
                    'position',[0.43 0.85-0.05*t 0.03 0.04],...
                     'units','normalized',...
                     'callback',string);
  string=['ruledef(',num2str(i+1),')'];
  handle(i+1)=uicontrol('style','pushbutton','string','-',...
                     'position',[0.47 0.85-0.05*t 0.03 0.04],...
                      'units','normalized',...
                      'callback',string);
   i=i+2;                 
end

text(0.57 ,0.95,'OUTPUT-VARIABLES');

% analog wie oben: nur fuer ausgangs-(steuer-)groessen
for t=1:n_out
  text2=set(t+1,25:44);
  text(0.57 ,0.93-0.06*t,text2);
  string=['ruledef(',num2str(i),')'];

  h(n_in+t)=text(0.85,0.93-0.06*t,'ANY');
  handle(i)=uicontrol('style','pushbutton','string','+',...
                    'position',[0.86 0.85-0.05*t 0.03 0.04],...
                     'units','normalized',...
                      'callback',string);
  string=['ruledef(',num2str(i+1),')'];
  handle(i+1)=uicontrol('style','pushbutton','string','-',...
                     'position',[0.90 0.85-0.05*t 0.03 0.04],...
                      'units','normalized',...
                       'callback',string);
   i=i+2;                 
end

% hier def. von safety
saf=text(0.85,0.1,'SAFETY 1.0');
c__s=1.0;

safepl=uicontrol('style','pushbutton','string','+',...
                    'position',[0.86 0.1 0.03 0.04],...
                     'units','normalized',...
                      'callback','safety(1)');
safemin=uicontrol('style','pushbutton','string','-',...
                     'position',[0.9 0.1 0.03 0.04],...
                      'units','normalized',...
                       'callback','safety(2)');

save f__safe saf c__s;

save f__temp h n_in rule setdesc nr;

% zum schluss noch der OK-button, mit dem grafik-fenster geloescht wird
string='exit_button;';
hexit=uicontrol('style','pushbutton','string','OK',...
                     'position',[0.1 0.1 0.1 0.05],...
                      'units','normalized',...
                       'callback',string);

drawnow;
% darstellen aller objekte: jetzt

return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE



