function [setdesc]=makeset(set)

%MAKESET
%         [setdesc]=MAKESET(set) builds the set-description-matrix
%         'setdesc'. 'setdesc' contains the ranges of the input-fuzzy-
%         variables and the output-fuzzy-variables.
%         'set' must be a fuzzy-set matrix (i.e. of type SET), which is a
%         result of the function OUTDEF.
%
%         See also: OUTDEF, INDEF, EDITSET

% Stephan Molt 01-09-93

[zz1,ss1]=size(set);
if(ss1~=48)
   error('argument must be of type SET');
end

% pruefen, ob objekte vom richtigen typ sind
n_in=abs(set(1,1));
n_out=abs(set(1,21));
zeil=max(n_in,n_out);
setdesc=zeros(zeil,6);

% schleife ueber alle eingangsgroessen; eingabe der sektionen,
% des arbeitspunktes und der groesse des intervalls
for ii=1:1:n_in
  while(1==1)
	clc;
	var=set(ii+1,1:20);
        var=[' Input-Variable ',num2str(ii),': ',var];
	disp(var);
	ein=input('Number of sections: ','s');
	ein=abs(ein)-48;
	if( ~(ein==3 | ein==5 | ein==7 | ein==9) )
	   disp(' Error - you can choose 3, 5, 7 or 9 sections');
	   a=input('Hit any key to start again','s');
	else
	   break;   
	end
  end


  string=lingus(ein);
  % lingus stellt die linguistischen variablen bereit, die zu den unter-
  % teilungen gehoeren
  x0=input('working point x0: ');
  a=input('interval length h/2: ');
  a=abs(a);
  setdesc(ii,1)=ein;
  setdesc(ii,2)=x0;
  setdesc(ii,3)=a;
  showset(set,setdesc,1,ii);

  
end

% entsprechendes fuer die ausgangsgroessen
for ii=1:1:n_out
  while(1==1)
	clc;
	
	var=set(ii+1,25:44);

        var=[' Output-Variable ',num2str(ii),': ',var];
	disp(var);
	ein=input('Number of sections: ','s');
	ein=abs(ein)-48;
	if( ~(ein==3 | ein==5 | ein==7 | ein==9) )
	   disp(' Error - you can choose 3, 5, 7 or 9 sections');
	   a=input('Hit any key to start again','s');
	else
	   break;   
	end
  end


  string=lingus(ein);
 
  x0=input('working point x0: ');
  a=input('interval length h/2: ');
  a=abs(a);
  setdesc(ii,4)=ein;
  setdesc(ii,5)=x0;
  setdesc(ii,6)=a;
  showset(set,setdesc,2,ii);

end

return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
