function f=mul(f1,f2)

%MUL
%         f=MUL(f1,f2) returns the product of the fuzzy-figures 'f1' and
%         'f2'.
%         'f1' and 'f2' must be trapezoid fuzzy-figures; the result 'f' is 
%         also a trapezoid fuzzy-figure.
%         This algorithm uses the Dubois-Prade approximation.

% Stephan Molt 01-09-93

if(nargin~=2)
  error('wrong number of arguments - MUL requires two arguments');
end

[z1,s1]= size(f1);
[z2,s2]= size(f2);

if (~(z1==1 & s1==4))
   error('first argument must be trapezoid');
end

if(~(z2==1 & s2==4))
   error('second argument must be trapezoid');
end

f(1)=f1(1)*f2(1);
f(2)=f1(2)*f2(2);
f(3)=f1(1)*f2(3)+f2(1)*f1(3)-f1(3)*f2(3);
f(4)=f1(2)*f2(4)+f2(2)*f1(4)+f1(4)*f2(4);


return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
