function [xs,moment,area]=tunfuzzy(x)

%TUNFUZZY
%         [u]=TUNFUZZY(uf) (trapezoid unfuzzy) computes a sharp figure 'u'
%         from the fuzzy-figure 'uf'. 'uf' must be a non-discrete fuzzy-
%         figure.

%   Stephan Molt 01-09-93

[z,s]=size(x);
% analyse function call
if(nargin>1)
  error('wrong number of arguments - TUNFUZZY requires one argument')
end
if s==4,
   [n,m,alpha,beta]=copy4(x);
   ymax=1;
elseif (s==5),
   [n,m,alpha,beta,ymax]=copy5(x);
else, 
   error('fuzzy-figure must have either 4 or 5 columns')
end

% hier: divisionsfehler abfangen
if(alpha==0)
   alpha=0.0001;
end
if(beta==0)
   beta=0.0001;
end

a=ymax/alpha; b=(alpha-n)*ymax/alpha; 
c=-ymax/beta; d=(m+beta)*ymax/beta;

% fuer jemanden, der nichts davon versteht, ist diese berechnung voellig
% undurschaubar
% es geht aber im prinzip darum, die fuzzy-zahl in drei bereiche zu
% unterteilen, und von jeder geometrischen figur (2 dreiecke und 1 recht-
% eck) den schwerpunkt zu berechnen und diese dann zusammenzufassen
% allgemein berechnet sich der schwerpunkt als moment einer funktion durch
% deren flaeche mit einer bestehenden achse
% this means: its to hard to describe what's implemented down below

xo1=n; xu1=n-alpha;
m1o=1/3*a*xo1*xo1*xo1+.5*b*xo1*xo1;
m1u=1/3*a*xu1*xu1*xu1+.5*b*xu1*xu1;
m1=m1o-m1u;

xo2=m; xu2=n;
m2o=.5*ymax*xo2*xo2;
m2u=.5*ymax*xu2*xu2;
m2=m2o-m2u;

xo3=m+beta; xu3=m;
mo3=1/3*c*xo3*xo3*xo3+.5*d*xo3*xo3;
mu3=1/3*c*xu3*xu3*xu3+.5*d*xu3*xu3;
m3=mo3-mu3;

moment=m1+m2+m3;
area=ymax*(0.5*(alpha+beta)+m-n);

xs=moment/area;

return


%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE

