/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*- Mode:C++ -*-                                 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include "object.h"
#include "message.h"
#include "function.h"
#include "symbol.h"
#include "hash.h"
#include "exit.h"
#include "boolean.h"

extern "C" {
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <netdb.h>
};

#ifdef _UN_USE_YACC_
#include "parser.h"
#else
#include "parse.tab.h"
#endif

#define SIZE_OF_READ_ONE_TIME 512

#ifdef _DISABLE_GL_
extern char parse_buffer[BUFSIZ];
extern char* parse_point;
#endif
extern hash hash_table;
extern int is_inet_domain;
extern int is_data_gram;
extern int is_unix_domain;
extern int is_on_socket;
extern int line_number;
extern int nameleng;
extern struct sockaddr_in inet_client;
extern int is_reserve_string(int i);
extern int reserved_word(YYSTYPE* yylv,int index);

char buff[BUFSIZ];           /*ǥХϤȤ뤿ΥХåե*/
char rbuff[BUFSIZ];          /*ϤԤʤΥХåե*/
char* buffer_top;            /*ϥХåեβϤƬ򼨤ݥ*/
char* buffer_bottom;         /*ϥХåեβϤκǸ򼨤ݥ*/
int letter;                  /*ʸ*/
static char val_str[BUFSIZ]; /*ʸǼХåե*/
static int val_i = 0;        /*Ϥλͤݻ*/
static float val_d = 0;      /*Ϥ¿λ˼¿ͤݻ*/
int file_discript;           /*ϥǥХΥեǥץ*/
static int quote_flag;       /*ʸ󤬡ɤǰϤޤ줿ΤǤ뤫ɤΥե饰*/
int is_read_eof;             /*End of fileɤ߹Υե饰*/
int kind_of_letter;
int term_dummy;
char line_buffer[BUFSIZ];
char* current_line_buffers;

void reset_line_buffer()
{
#ifdef DEBUG
  fprintf(stderr,"void reset_line_buffer()\n");
#endif
  current_line_buffers = line_buffer;
  line_buffer[0] = '\0';
}

void lex_initialize()
{
#ifdef _DISABLE_GL_
  parse_point = parse_buffer;
  *parse_point = '\0';
#endif
  term_dummy = FALSE;
  file_discript = 0;
  buffer_bottom = buff;
  buffer_top = buff;
  is_read_eof = FALSE;
  reset_line_buffer();
}

int read_buff()
{
#ifdef DEBUG
  fprintf(stderr,"int read_buff()\n");
#endif
  int nbytes = 0;
  if (is_on_socket) {
    if (is_inet_domain == TRUE) {
      if (is_data_gram == TRUE) {
	nameleng = sizeof(inet_client);
#ifdef DEBUG
	fprintf(stderr,"recvfrom\n");
#endif
	if ((nbytes = recvfrom(file_discript,rbuff,SIZE_OF_READ_ONE_TIME,0,&inet_client,&nameleng))<0){
	  fprintf(stderr,"Fatal : \nSyscall recvfrom \n");
	  error_exit();
	}
	if (sendto(file_discript,rbuff,nbytes,0,&inet_client,nameleng)<0) {
	  fprintf(stderr,"Fatal : \nSyscall sendto \n");
	  error_exit();
	}
      }else{
#ifdef DEBUG
	fprintf(stderr,"recv\n");
#endif
	nbytes = recv(file_discript,rbuff,SIZE_OF_READ_ONE_TIME,0);
      }
    } else {
#ifdef DEBUG
      fprintf(stderr,"read\n");
#endif
      nbytes = read(file_discript,rbuff,SIZE_OF_READ_ONE_TIME);
    }
  } else {
    nbytes = read(file_discript,rbuff,SIZE_OF_READ_ONE_TIME);
  }
#ifdef DEBUG
  fprintf(stderr,"nbytes %d\n",nbytes);
#endif
  switch (nbytes) {
  case 0:
    *buffer_bottom = 0xff;
    is_read_eof = TRUE;
    buffer_bottom++;
    buffer_bottom = ((buffer_bottom-buff) == BUFSIZ) ? buff : buffer_bottom;
    break;
  case -1:
    break;
  default:
    int co;
    char* wp;
    for (wp = rbuff,co = nbytes;co > 0 ;wp++,co--) {
      *buffer_bottom = *wp;
      buffer_bottom++;
      buffer_bottom = ((buffer_bottom-buff) == BUFSIZ) ? buff : buffer_bottom;
    }
    break;
  }
  //fprintf(stderr," read nbytes  %d\n", nbytes);
  return nbytes;
}

void putback()
{
//#ifdef DEBUG
//  fprintf(stderr,"void putback()\n");
//#endif
  *current_line_buffers = '\0';
#ifdef _DISABLE_GL_
  *parse_point = '\0';
#endif
  if (buffer_top == buff) {
    buffer_top = buff+BUFSIZ-1;
    if(current_line_buffers != line_buffer)current_line_buffers--;
#ifdef _DISABLE_GL_
    if (parse_point != parse_buffer)parse_point--;
#endif
  } else {
    buffer_top--;
    if(current_line_buffers != line_buffer)current_line_buffers--;
#ifdef _DISABLE_GL_
    if (parse_point != parse_buffer)parse_point--;
#endif
  }
}

char getletter()
{
//#ifdef DEBUG
//  fprintf(stderr,"char getletter()\n");
//#endif
  char ret;
  char* cp = buffer_top;
  buffer_top++;
  buffer_top = ((buffer_top - buff) == BUFSIZ) ? buff : buffer_top;
  if (buffer_top == buffer_bottom) {
    if (read_buff() < 0){ 
      ret = 0;
//#ifdef DEBUG
//      fprintf(stderr,"return %d\n",ret);
//#endif
      return ret;
    }else {
      *current_line_buffers = *cp;
#ifdef _DISABLE_GL_
      *parse_point = *cp;
#endif
      ret = *cp ;
#ifdef _DISABLE_GL_
      if (*cp != '\0') parse_point++;
      *parse_point = '\0';
#endif
      if (*cp != '\0') current_line_buffers++;
      *current_line_buffers = '\0';
    }
  }else {
    *current_line_buffers = *cp;
#ifdef _DISABLE_GL_
    *parse_point = *cp;
#endif
    ret = *cp ;
#ifdef _DISABLE_GL_
    if (*cp != '\0') parse_point++;
    *parse_point = '\0';
#endif
    if (*cp != '\0') current_line_buffers++;
    *current_line_buffers = '\0';
  }
//#ifdef DEBUG
//  if (isprint(ret)){
//    fprintf(stderr,"return %d (%c)\n ",ret,ret);
//  }else{
//    fprintf(stderr,"return %d\n",ret);
//  }
//#endif
  return ret;
}

int read_numerical()
{
  //fprintf(stderr,"read_numerical\n");
  int status = INTEGER;
  val_i = 0;
  val_d = 0;
  int i_m = 10;
  float d_m = 1.0;
  for (;;) {
    //fprintf(stderr," val_i %d val_d %f \n",val_i,val_d);
    letter = getletter();
    switch (letter) {
    case '0': case '1': case '2': case '3': case '4': case '5':
    case '6': case '7': case '8': case '9':
      if (status == INTEGER) {
	val_i *= i_m;
	val_i += letter - '0';
      } else {
	val_d += (letter - '0')*d_m;
	d_m *= 0.1;
      }
      break;
    case '\0':
      //fprintf(stderr,"read_numerical zero\n");
      break;
    case '.':
      status = FLOAT;
      val_d = (float)val_i;
      d_m = d_m * 0.1;
      break;
    default:
      putback();
      return status;
    }
  }
}

void get_string() 
{
  char* wp = val_str;
  for(;;) {
    letter = getletter();
    switch(letter) {
    case '\0':
      break;
    case 0xff:
      return;
    case ' ':   case '\t':  case '\n':  case ':':  case ',':   case '(': 
    case ')':   case '.':   case '-':   case '+':   case '*':   case '/': 
    case '{':   case '}': case '[': case ']':   case ';':
      if (quote_flag == FALSE) {
	*wp = '\0';
	putback();
	return;
      } else {
	*wp = letter;
	wp++;
	*wp = '\0';
	break;
      }
    case '\'':
      if (kind_of_letter == '\'') {
	return;
      }else{
	break;
      }
    case '"':
      if (kind_of_letter == '"') {
	return;
      } else {
	break;
      }
    case '\\':
      letter = getletter();
      *wp = letter;
      wp++;
      *wp = '\0';
      break;
    default:
      *wp = letter;
      wp++;
      *wp = '\0';
      break;
    }
  }
}

int reserved_word()
{
  char* wp = val_str;
  int id = hash_table.wordId(val_str);
  yylval.ival = id;
  if(!is_reserve_string(id)) {
    return SYMBOL;
  }
  return reserved_word(&yylval,id);
}

inline int get_hex()
{
  int value = 0;
  for (;;){
    int let = getletter(); 
    let = (isalpha(let)) ? tolower(let):let;
    if (isdigit(let)) {
      value <<= 4;
      value += (let-'0') ;
    } else if (isxdigit(let)) {
      value <<= 4;
      value += (let-'a')+0xa;
    } else {
      putback();
      return value;
    }
  }
}
inline int get_oct()
{
  int value = 0;
  for (;;){
    int let = getletter(); 
    if (isdigit(let) && (let <= '7')) {
      value <<= 3;
      value += (let-'0') ;
    } else {
      putback();
      return value;
    }
  }
}
int numeric_object()
{
  putback();
  if (read_numerical() == FLOAT) {
    yylval.fval = val_d;
    return FLOAT;
  }
  yylval.ival = val_i;
  return INTEGER;
}

int yylex_body() 
{
  quote_flag = FALSE;	
  if (term_dummy == TRUE) {
    term_dummy = FALSE;
    return 0;
  }
  int id;
  for (;;) {
    letter = getletter();
    if (letter == 0xff) {
      return 0;
    }
    if (letter < 0) {
      break;
    }
    if (letter == '0') {
      int next;
      next = getletter();
      if (next == 'x') {
	yylval.ival = get_hex();
	return INTEGER;
      }else if ((isdigit(next))&&(next <= '7')) {
	yylval.ival = get_oct();
	return INTEGER;
      }
      putback();
    }
    if (isdigit(letter)) {
      return numeric_object();
    }
    switch (letter) {
    case '\0':
      if (is_read_eof == TRUE) {
	return ENDFILE;
      }
      break;
    case ' ': case '\t':
      break;
    case '.':
      return numeric_object();
    case '\n':
      reset_line_buffer();
      line_number++;
      break;
    case '=':
      yylval.midval = METHOD_COPY;
      return METHOD_NAME;
    case ';':
      term_dummy = TRUE;
      return TE;
    case '#':
      for (letter = getletter();letter != '\n';letter = getletter()) ;
      putback();
      break;
    case ':': return QS;
    case ',': return COMMA;
    case '(': return BGNSTR;
    case ')': return ENDSTR;
    case '[': return BGNLIST;
    case ']': return ENDLIST;
    case '{': return BGNARGS;
    case '}': return ENDARGS;
    case '-': return MINUS;
    case '+': return PLUS;
    case '*': return MUL;
    case '/': return DIV;
    case '\'':
      kind_of_letter = '\'';
      quote_flag = TRUE;	
      get_string();
      quote_flag = FALSE;
      id = hash_table.wordId(val_str);
      yylval.ival = id;
      return SYMBOL;
    case '"':
      kind_of_letter = '"';
      quote_flag = TRUE;	
      get_string();
      quote_flag = FALSE;	
      id = hash_table.wordId(val_str);
      yylval.ival = id;
      return STRING;
    default:
      kind_of_letter = ' ';
      putback();
      get_string();
      //fprintf(stderr,"get_string(%s)\n",val_str);
      return reserved_word();
    }
  }
  /*dummy*/
  return 0;
}
int yylex() 
{
  int ret = yylex_body();
#ifdef DEBUG
  fprintf(stderr," token %d buffer_top %x buffer_bottom %x\n",
	ret,(unsigned)(buffer_top),(unsigned)(buffer_bottom));
#endif
  return ret;
}
